rule win_rtpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rtpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rtpos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c408 c745fcffffffff 8d4dc0 e8???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     

        $sequence_1 = { 50 8d8df4fdffff 51 8b95f0fdffff 8b421c 50 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d8df4fdffff         | lea                 ecx, [ebp - 0x20c]
            //   51                   | push                ecx
            //   8b95f0fdffff         | mov                 edx, dword ptr [ebp - 0x210]
            //   8b421c               | mov                 eax, dword ptr [edx + 0x1c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { 6a01 6a00 6a01 6a04 8d8de8fdffff }
            // n = 5, score = 100
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6a04                 | push                4
            //   8d8de8fdffff         | lea                 ecx, [ebp - 0x218]

        $sequence_3 = { 894dbc 8b55bc 0fb602 50 }
            // n = 4, score = 100
            //   894dbc               | mov                 dword ptr [ebp - 0x44], ecx
            //   8b55bc               | mov                 edx, dword ptr [ebp - 0x44]
            //   0fb602               | movzx               eax, byte ptr [edx]
            //   50                   | push                eax

        $sequence_4 = { 8b4508 56 be???????? c745ecfcad4200 }
            // n = 4, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   be????????           |                     
            //   c745ecfcad4200       | mov                 dword ptr [ebp - 0x14], 0x42adfc

        $sequence_5 = { 8bec 83ec44 894dfc c745d800000000 682c020000 6a00 }
            // n = 6, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec44               | sub                 esp, 0x44
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   682c020000           | push                0x22c
            //   6a00                 | push                0

        $sequence_6 = { 6bf830 894df8 6a0a 8b048db86a4300 5b 8b543818 8955ec }
            // n = 7, score = 100
            //   6bf830               | imul                edi, eax, 0x30
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   6a0a                 | push                0xa
            //   8b048db86a4300       | mov                 eax, dword ptr [ecx*4 + 0x436ab8]
            //   5b                   | pop                 ebx
            //   8b543818             | mov                 edx, dword ptr [eax + edi + 0x18]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx

        $sequence_7 = { 8985ecfdffff 6808020000 6a00 8d85f4fdffff 50 e8???????? 83c40c }
            // n = 7, score = 100
            //   8985ecfdffff         | mov                 dword ptr [ebp - 0x214], eax
            //   6808020000           | push                0x208
            //   6a00                 | push                0
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_8 = { 8bec 51 894dfc 0fbe4508 83f830 7c12 0fbe4d08 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   0fbe4508             | movsx               eax, byte ptr [ebp + 8]
            //   83f830               | cmp                 eax, 0x30
            //   7c12                 | jl                  0x14
            //   0fbe4d08             | movsx               ecx, byte ptr [ebp + 8]

        $sequence_9 = { c745a000000000 e9???????? 8b4508 83c001 894508 8b4d0c }
            // n = 6, score = 100
            //   c745a000000000       | mov                 dword ptr [ebp - 0x60], 0
            //   e9????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c001               | add                 eax, 1
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 507904
}