rule win_ryuk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ryuk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ryuk"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 6a01 6a00 6814010000 }
            // n = 4, score = 2400
            //   68????????           |                     
            //   6a01                 | lea                 edi, [edx - 2]
            //   6a00                 | mov                 ax, word ptr [edi + 2]
            //   6814010000           | lea                 edi, [edi + 2]

        $sequence_1 = { 85c0 7508 6a01 ff15???????? 68???????? 6a01 }
            // n = 6, score = 2300
            //   85c0                 | test                ax, ax
            //   7508                 | jne                 3
            //   6a01                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff15????????         |                     
            //   68????????           |                     
            //   6a01                 | mov                 ecx, eax

        $sequence_2 = { 6a08 6a18 68???????? 68???????? 68???????? }
            // n = 5, score = 1900
            //   6a08                 | test                ax, ax
            //   6a18                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_3 = { 7578 6a10 6a18 68???????? }
            // n = 4, score = 1800
            //   7578                 | sub                 eax, edx
            //   6a10                 | shr                 eax, 1
            //   6a18                 | add                 eax, edx
            //   68????????           |                     

        $sequence_4 = { 66398818000035 753e 8b4508 b9???????? 2bc1 50 }
            // n = 6, score = 1800
            //   66398818000035       | dec                 eax
            //   753e                 | mov                 eax, ebx
            //   8b4508               | dec                 eax
            //   b9????????           |                     
            //   2bc1                 | add                 esp, 0x30
            //   50                   | pop                 ebx

        $sequence_5 = { 68???????? 68???????? 68???????? ff15???????? 85c0 7525 6a08 }
            // n = 7, score = 1800
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | sub                 edx, esi
            //   7525                 | lea                 ebx, [edi + 2]
            //   6a08                 | mov                 ax, word ptr [edi + 2]

        $sequence_6 = { ff15???????? 85c0 7542 6a28 6a18 68???????? }
            // n = 6, score = 1800
            //   ff15????????         |                     
            //   85c0                 | shr                 eax, 6
            //   7542                 | imul                eax, eax, 0x5a
            //   6a28                 | sub                 eax, edx
            //   6a18                 | shr                 eax, 1
            //   68????????           |                     

        $sequence_7 = { ff15???????? 85c0 7578 6a10 }
            // n = 4, score = 1800
            //   ff15????????         |                     
            //   85c0                 | push                0x18
            //   7578                 | test                eax, eax
            //   6a10                 | jne                 0x27

        $sequence_8 = { 81b8????????50450000 754c b90b010000 66398818000035 753e 8b4508 }
            // n = 6, score = 1800
            //   81b8????????50450000     |     
            //   754c                 | ret                 
            //   b90b010000           | dec                 eax
            //   66398818000035       | mov                 dword ptr [esp + 8], ebx
            //   753e                 | push                edi
            //   8b4508               | dec                 eax

        $sequence_9 = { 68c0cf6a00 ff15???????? 6a01 ff15???????? }
            // n = 4, score = 1700
            //   68c0cf6a00           | push                1
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   ff15????????         |                     

        $sequence_10 = { e8???????? 68e8030000 ff15???????? 68???????? e8???????? }
            // n = 5, score = 1400
            //   e8????????           |                     
            //   68e8030000           | ret                 
            //   ff15????????         |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_11 = { 7407 b801000000 eb0b eb04 33c0 eb05 b801000000 }
            // n = 7, score = 1400
            //   7407                 | push                0x18
            //   b801000000           | test                eax, eax
            //   eb0b                 | jne                 0x44
            //   eb04                 | push                0x28
            //   33c0                 | push                0x18
            //   eb05                 | test                eax, eax
            //   b801000000           | jne                 0x7a

        $sequence_12 = { ba01000000 c1e200 8b45fc 880c10 b904000000 6bd103 817c15d8ff000000 }
            // n = 7, score = 1300
            //   ba01000000           | test                eax, eax
            //   c1e200               | jne                 0x46
            //   8b45fc               | push                0x28
            //   880c10               | push                0x18
            //   b904000000           | test                eax, eax
            //   6bd103               | jne                 0x7c
            //   817c15d8ff000000     | push                0x10

        $sequence_13 = { b804000000 c1e000 8b4c05d8 83c101 ba04000000 c1e200 894c15d8 }
            // n = 7, score = 1300
            //   b804000000           | test                eax, eax
            //   c1e000               | jne                 0x7c
            //   8b4c05d8             | push                0x10
            //   83c101               | push                0x18
            //   ba04000000           | test                eax, eax
            //   c1e200               | jne                 0x27
            //   894c15d8             | push                8

        $sequence_14 = { 2b4df4 394dfc 7312 ba01000000 }
            // n = 4, score = 1300
            //   2b4df4               | push                0x18
            //   394dfc               | jne                 0x27
            //   7312                 | push                8
            //   ba01000000           | push                0x18

        $sequence_15 = { ba01000000 8b4df0 d3e2 0b55f8 8955f8 ebd6 eb02 }
            // n = 7, score = 1300
            //   ba01000000           | jne                 0x7a
            //   8b4df0               | push                0x10
            //   d3e2                 | push                0x18
            //   0b55f8               | test                eax, eax
            //   8955f8               | jne                 0x46
            //   ebd6                 | push                0x28
            //   eb02                 | push                0x18

        $sequence_16 = { 0f870b020000 720c 8b459c 3b45f4 0f87fd010000 b904000000 c1e100 }
            // n = 7, score = 1300
            //   0f870b020000         | push                0x18
            //   720c                 | test                eax, eax
            //   8b459c               | jne                 0x46
            //   3b45f4               | push                0x28
            //   0f87fd010000         | test                eax, eax
            //   b904000000           | jne                 0x46
            //   c1e100               | push                0x28

        $sequence_17 = { 6bc203 8b4dfc c6040100 ba01000000 d1e2 8b45fc c6041000 }
            // n = 7, score = 1300
            //   6bc203               | push                0x18
            //   8b4dfc               | test                eax, eax
            //   c6040100             | jne                 0x4a
            //   ba01000000           | push                0x28
            //   d1e2                 | test                eax, eax
            //   8b45fc               | jne                 0x7c
            //   c6041000             | push                0x10

        $sequence_18 = { ff15???????? b811000000 e9???????? e9???????? }
            // n = 4, score = 1200
            //   ff15????????         |                     
            //   b811000000           | test                eax, eax
            //   e9????????           |                     
            //   e9????????           |                     

        $sequence_19 = { 7407 48 85c0 7ff0 }
            // n = 4, score = 900
            //   7407                 | dec                 ecx
            //   48                   | mov                 ebx, eax
            //   85c0                 | dec                 eax
            //   7ff0                 | mov                 eax, ebx

        $sequence_20 = { 6a00 6814010000 ff7508 ff35???????? ff15???????? }
            // n = 5, score = 900
            //   6a00                 | push                ebx
            //   6814010000           | dec                 eax
            //   ff7508               | sub                 esp, 0x20
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_21 = { ff35???????? ff15???????? 833d????????00 6a10 6a18 }
            // n = 5, score = 900
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   833d????????00       |                     
            //   6a10                 | inc                 eax
            //   6a18                 | push                ebx

        $sequence_22 = { 751b ff35???????? ff35???????? 6a01 68???????? e8???????? 83c410 }
            // n = 7, score = 800
            //   751b                 | jne                 0x18
            //   ff35????????         |                     
            //   ff35????????         |                     
            //   6a01                 | cmp                 word ptr [edi + 2], 0x54
            //   68????????           |                     
            //   e8????????           |                     
            //   83c410               | jne                 0x18

        $sequence_23 = { ff15???????? b803000000 eb05 b805000000 }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   b803000000           | mov                 eax, 3
            //   eb05                 | jmp                 7
            //   b805000000           | mov                 eax, 5

        $sequence_24 = { 2bf0 33c0 66890473 83ffff }
            // n = 4, score = 800
            //   2bf0                 | cmp                 word ptr [edi + 2], 0x54
            //   33c0                 | jne                 0x18
            //   66890473             | cmp                 word ptr [edi + 6], 0x41
            //   83ffff               | jne                 0x18

        $sequence_25 = { 56 ff15???????? 8bcb 8d5102 }
            // n = 4, score = 700
            //   56                   | jne                 0x18
            //   ff15????????         |                     
            //   8bcb                 | cmp                 word ptr [edi + 2], 0x54
            //   8d5102               | jne                 0x18

        $sequence_26 = { e8???????? e8???????? b9e8030000 ff15???????? }
            // n = 4, score = 700
            //   e8????????           |                     
            //   e8????????           |                     
            //   b9e8030000           | mov                 ecx, 0x3e8
            //   ff15????????         |                     

        $sequence_27 = { 7714 7212 81f9d0070000 770a 85d2 }
            // n = 5, score = 700
            //   7714                 | jne                 0x40
            //   7212                 | mov                 eax, dword ptr [ebp + 8]
            //   81f9d0070000         | sub                 eax, ecx
            //   770a                 | push                eax
            //   85d2                 | jne                 0x4e

        $sequence_28 = { eb0b 8bc1 99 f7fe }
            // n = 4, score = 700
            //   eb0b                 | cmp                 word ptr [edi + 2], 0x54
            //   8bc1                 | jne                 0x18
            //   99                   | cmp                 word ptr [edi + 6], 0x41
            //   f7fe                 | jne                 0x18

        $sequence_29 = { 0f9fc0 5d c3 8bff 55 8bec 8b4508 }
            // n = 7, score = 600
            //   0f9fc0               | cmp                 word ptr [eax + 0x35000018], cx
            //   5d                   | jne                 0x40
            //   c3                   | mov                 eax, dword ptr [ebp + 8]
            //   8bff                 | jne                 0x4e
            //   55                   | mov                 ecx, 0x10b
            //   8bec                 | cmp                 word ptr [eax + 0x35000018], cx
            //   8b4508               | jne                 0x5f

        $sequence_30 = { 8d5f02 668b4702 83c702 6685c0 }
            // n = 4, score = 600
            //   8d5f02               | push                ebx
            //   668b4702             | mov                 ax, word ptr [edx]
            //   83c702               | add                 edx, 2
            //   6685c0               | test                ax, ax

        $sequence_31 = { 488bc3 4883c430 5b c3 48895c2408 48896c2410 }
            // n = 6, score = 600
            //   488bc3               | mov                 dword ptr [esp + 8], ebx
            //   4883c430             | push                edi
            //   5b                   | dec                 eax
            //   c3                   | sub                 esp, 0x30
            //   48895c2408           | and                 dword ptr [esp + 0x20], 0
            //   48896c2410           | mov                 ecx, 8

        $sequence_32 = { 53 d1fe e8???????? 83c408 8d5002 }
            // n = 5, score = 600
            //   53                   | shr                 eax, 1
            //   d1fe                 | add                 eax, edx
            //   e8????????           |                     
            //   83c408               | shr                 eax, 6
            //   8d5002               | mov                 eax, ecx

        $sequence_33 = { 6685c9 75f5 2bf2 68???????? 53 }
            // n = 5, score = 600
            //   6685c9               | xor                 eax, eax
            //   75f5                 | mov                 word ptr [ebx + esi*2], ax
            //   2bf2                 | cmp                 edi, -1
            //   68????????           |                     
            //   53                   | sar                 eax, 1

        $sequence_34 = { 8bc8 83e103 f3a4 8d7afe 668b4702 8d7f02 }
            // n = 6, score = 600
            //   8bc8                 | sub                 eax, edx
            //   83e103               | shr                 eax, 1
            //   f3a4                 | add                 eax, edx
            //   8d7afe               | shr                 eax, 6
            //   668b4702             | imul                eax, eax, 0x5a
            //   8d7f02               | mul                 ecx

        $sequence_35 = { 8d7f02 6685c0 75f4 a1???????? 8907 eb03 }
            // n = 6, score = 600
            //   8d7f02               | sub                 edx, esi
            //   6685c0               | sub                 esi, edx
            //   75f4                 | push                ebx
            //   a1????????           |                     
            //   8907                 | sar                 esi, 1
            //   eb03                 | add                 esp, 8

        $sequence_36 = { 83c202 6685c0 75f5 8d7bfe 2bd6 8d5f02 }
            // n = 6, score = 600
            //   83c202               | shr                 eax, 6
            //   6685c0               | imul                eax, eax, 0x5a
            //   75f5                 | mov                 eax, 0x6c16c16d
            //   8d7bfe               | mul                 ecx
            //   2bd6                 | mov                 eax, ecx
            //   8d5f02               | sub                 eax, edx

        $sequence_37 = { 498bc1 c3 4053 4883ec20 8bc1 498bd8 }
            // n = 6, score = 600
            //   498bc1               | dec                 eax
            //   c3                   | sub                 esp, 0x30
            //   4053                 | and                 dword ptr [esp + 0x20], 0
            //   4883ec20             | dec                 ecx
            //   8bc1                 | mov                 eax, ecx
            //   498bd8               | ret                 

        $sequence_38 = { 4883c428 c3 48895c2408 57 4883ec30 8364242000 }
            // n = 6, score = 600
            //   4883c428             | dec                 eax
            //   c3                   | add                 esp, 0x28
            //   48895c2408           | ret                 
            //   57                   | dec                 eax
            //   4883ec30             | mov                 dword ptr [esp + 8], ebx
            //   8364242000           | push                edi

        $sequence_39 = { ba00000040 ff15???????? 488bd8 ff15???????? 83f820 }
            // n = 5, score = 500
            //   ba00000040           | push                0x18
            //   ff15????????         |                     
            //   488bd8               | push                8
            //   ff15????????         |                     
            //   83f820               | push                0x18

        $sequence_40 = { ff15???????? 41b900800000 4533c0 488bd6 488bcf }
            // n = 5, score = 500
            //   ff15????????         |                     
            //   41b900800000         | dec                 ecx
            //   4533c0               | mov                 eax, ecx
            //   488bd6               | ret                 
            //   488bcf               | inc                 eax

        $sequence_41 = { 66837f0254 750f 66837f0641 7508 }
            // n = 4, score = 500
            //   66837f0254           | dec                 eax
            //   750f                 | sub                 esp, 0x20
            //   66837f0641           | mov                 eax, ecx
            //   7508                 | dec                 ecx

        $sequence_42 = { 66833f4e 7516 66837f0254 750f }
            // n = 4, score = 500
            //   66833f4e             | mov                 eax, ebx
            //   7516                 | dec                 eax
            //   66837f0254           | add                 esp, 0x30
            //   750f                 | pop                 ebx

        $sequence_43 = { 33c9 ba10270000 41b800100000 448d4904 ff15???????? }
            // n = 5, score = 500
            //   33c9                 | push                0x114
            //   ba10270000           | push                8
            //   41b800100000         | push                0x18
            //   448d4904             | push                8
            //   ff15????????         |                     

        $sequence_44 = { d1e8 03c2 c1e806 6bc05a }
            // n = 4, score = 500
            //   d1e8                 | mov                 dword ptr [esp + 8], ebx
            //   03c2                 | dec                 eax
            //   c1e806               | mov                 dword ptr [esp + 0x10], ebp
            //   6bc05a               | dec                 eax

        $sequence_45 = { e8???????? 99 2bc2 d1f8 85c0 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   99                   | jne                 0x4e
            //   2bc2                 | mov                 ecx, 0x10b
            //   d1f8                 | cmp                 word ptr [eax + 0x35000018], cx
            //   85c0                 | jne                 0x4e

        $sequence_46 = { 33c9 ff15???????? 48897c2430 488d4c2440 c744242802000000 4533c9 }
            // n = 6, score = 500
            //   33c9                 | jne                 0x40
            //   ff15????????         |                     
            //   48897c2430           | mov                 eax, dword ptr [ebp + 8]
            //   488d4c2440           | mov                 ecx, 0x10b
            //   c744242802000000     | cmp                 word ptr [eax + 0x35000018], cx
            //   4533c9               | jne                 0x47

        $sequence_47 = { 8b5c3050 ff15???????? 41b900300000 c744242040000000 }
            // n = 4, score = 500
            //   8b5c3050             | and                 eax, 0x103
            //   ff15????????         |                     
            //   41b900300000         | pop                 ebp
            //   c744242040000000     | ret                 

        $sequence_48 = { ff15???????? 488bf8 4885c0 7410 ff15???????? 488bc8 }
            // n = 6, score = 500
            //   ff15????????         |                     
            //   488bf8               | mov                 eax, dword ptr [ebp + 8]
            //   4885c0               | sub                 eax, ecx
            //   7410                 | push                0x6acfc0
            //   ff15????????         |                     
            //   488bc8               | push                1

        $sequence_49 = { e8???????? 84c0 746c e8???????? 488d0d63080000 e8???????? e8???????? }
            // n = 7, score = 400
            //   e8????????           |                     
            //   84c0                 | jne                 0x7a
            //   746c                 | push                0x10
            //   e8????????           |                     
            //   488d0d63080000       | test                eax, eax
            //   e8????????           |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 7450624
}