rule win_satana_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.satana."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.satana"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8578ffffff 50 56 51 ffd7 8b4df0 6a00 }
            // n = 7, score = 100
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   50                   | push                eax
            //   56                   | push                esi
            //   51                   | push                ecx
            //   ffd7                 | call                edi
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   6a00                 | push                0

        $sequence_1 = { bfff000000 f7ff 8a8258fd4000 8845fe eb04 }
            // n = 5, score = 100
            //   bfff000000           | mov                 edi, 0xff
            //   f7ff                 | idiv                edi
            //   8a8258fd4000         | mov                 al, byte ptr [edx + 0x40fd58]
            //   8845fe               | mov                 byte ptr [ebp - 2], al
            //   eb04                 | jmp                 6

        $sequence_2 = { 689f011200 56 ff15???????? 8bf8 897da8 }
            // n = 5, score = 100
            //   689f011200           | push                0x12019f
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   897da8               | mov                 dword ptr [ebp - 0x58], edi

        $sequence_3 = { 50 ff15???????? be???????? e8???????? 0fb60d???????? 51 6a02 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   be????????           |                     
            //   e8????????           |                     
            //   0fb60d????????       |                     
            //   51                   | push                ecx
            //   6a02                 | push                2

        $sequence_4 = { 0f8418010000 68ff0f0000 8d85fdefffff 6a00 50 c685fcefffff00 e8???????? }
            // n = 7, score = 100
            //   0f8418010000         | je                  0x11e
            //   68ff0f0000           | push                0xfff
            //   8d85fdefffff         | lea                 eax, [ebp - 0x1003]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c685fcefffff00       | mov                 byte ptr [ebp - 0x1004], 0
            //   e8????????           |                     

        $sequence_5 = { 52 68???????? e8???????? a1???????? 83c408 6aff 6a01 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   68????????           |                     
            //   e8????????           |                     
            //   a1????????           |                     
            //   83c408               | add                 esp, 8
            //   6aff                 | push                -1
            //   6a01                 | push                1

        $sequence_6 = { ff15???????? 8bce a3???????? 85c9 7412 8d9b00000000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8bce                 | mov                 ecx, esi
            //   a3????????           |                     
            //   85c9                 | test                ecx, ecx
            //   7412                 | je                  0x14
            //   8d9b00000000         | lea                 ebx, [ebx]

        $sequence_7 = { ebeb e8???????? e9???????? 8b45b8 85c0 7403 880437 }
            // n = 7, score = 100
            //   ebeb                 | jmp                 0xffffffed
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   880437               | mov                 byte ptr [edi + esi], al

        $sequence_8 = { c745f478817e51 66c745f88500 e8???????? 8b15???????? 50 }
            // n = 5, score = 100
            //   c745f478817e51       | mov                 dword ptr [ebp - 0xc], 0x517e8178
            //   66c745f88500         | mov                 word ptr [ebp - 8], 0x85
            //   e8????????           |                     
            //   8b15????????         |                     
            //   50                   | push                eax

        $sequence_9 = { 68???????? 57 8945e4 ffd3 }
            // n = 4, score = 100
            //   68????????           |                     
            //   57                   | push                edi
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   ffd3                 | call                ebx

    condition:
        7 of them and filesize < 221184
}