rule win_scieron_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.scieron."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scieron"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff742418 ff15???????? 85c0 0f8472020000 f686????????10 7415 }
            // n = 6, score = 100
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8472020000         | je                  0x278
            //   f686????????10       |                     
            //   7415                 | je                  0x17

        $sequence_1 = { ffd0 85f6 0f8497010000 6800800000 8d44242c }
            // n = 5, score = 100
            //   ffd0                 | call                eax
            //   85f6                 | test                esi, esi
            //   0f8497010000         | je                  0x19d
            //   6800800000           | push                0x8000
            //   8d44242c             | lea                 eax, [esp + 0x2c]

        $sequence_2 = { 6800000080 83c008 50 ff15???????? 8bf8 }
            // n = 5, score = 100
            //   6800000080           | push                0x80000000
            //   83c008               | add                 eax, 8
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_3 = { 72f0 33c0 663b45f0 7560 8a45f4 8b4d08 }
            // n = 6, score = 100
            //   72f0                 | jb                  0xfffffff2
            //   33c0                 | xor                 eax, eax
            //   663b45f0             | cmp                 ax, word ptr [ebp - 0x10]
            //   7560                 | jne                 0x62
            //   8a45f4               | mov                 al, byte ptr [ebp - 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_4 = { 3bfd 7507 33c0 e9???????? 8b742418 6a0c 57 }
            // n = 7, score = 100
            //   3bfd                 | cmp                 edi, ebp
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b742418             | mov                 esi, dword ptr [esp + 0x18]
            //   6a0c                 | push                0xc
            //   57                   | push                edi

        $sequence_5 = { e8???????? 8bf8 83c410 3bfe 0f841bffffff }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c410               | add                 esp, 0x10
            //   3bfe                 | cmp                 edi, esi
            //   0f841bffffff         | je                  0xffffff21

        $sequence_6 = { 0f8401010000 6a04 8d4c2410 51 }
            // n = 4, score = 100
            //   0f8401010000         | je                  0x107
            //   6a04                 | push                4
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   51                   | push                ecx

        $sequence_7 = { 8bf8 3bfe 7419 8d4574 50 57 }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   3bfe                 | cmp                 edi, esi
            //   7419                 | je                  0x1b
            //   8d4574               | lea                 eax, [ebp + 0x74]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_8 = { 033e 68???????? 68???????? ff15???????? 50 ff15???????? ffd0 }
            // n = 7, score = 100
            //   033e                 | add                 edi, dword ptr [esi]
            //   68????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ffd0                 | call                eax

        $sequence_9 = { ff15???????? 50 ff15???????? ffd0 83c61c }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ffd0                 | call                eax
            //   83c61c               | add                 esi, 0x1c

    condition:
        7 of them and filesize < 100352
}