rule win_scranos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.scranos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scranos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5510 0355fc 8a02 8845fb 0fbe4dfb 85c9 0f848a000000 }
            // n = 7, score = 100
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   0355fc               | add                 edx, dword ptr [ebp - 4]
            //   8a02                 | mov                 al, byte ptr [edx]
            //   8845fb               | mov                 byte ptr [ebp - 5], al
            //   0fbe4dfb             | movsx               ecx, byte ptr [ebp - 5]
            //   85c9                 | test                ecx, ecx
            //   0f848a000000         | je                  0x90

        $sequence_1 = { b83f000000 5b 83c408 c3 894f10 894714 8b96280c0000 }
            // n = 7, score = 100
            //   b83f000000           | mov                 eax, 0x3f
            //   5b                   | pop                 ebx
            //   83c408               | add                 esp, 8
            //   c3                   | ret                 
            //   894f10               | mov                 dword ptr [edi + 0x10], ecx
            //   894714               | mov                 dword ptr [edi + 0x14], eax
            //   8b96280c0000         | mov                 edx, dword ptr [esi + 0xc28]

        $sequence_2 = { 8b55e8 3b956cffffff 0f8d9c000000 8b45e8 8b8c8530ffffff 8b55e8 8b4154 }
            // n = 7, score = 100
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   3b956cffffff         | cmp                 edx, dword ptr [ebp - 0x94]
            //   0f8d9c000000         | jge                 0xa2
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b8c8530ffffff       | mov                 ecx, dword ptr [ebp + eax*4 - 0xd0]
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8b4154               | mov                 eax, dword ptr [ecx + 0x54]

        $sequence_3 = { 8b55e8 8b451c 8b0c90 6bc918 8b5514 8b4204 8b0c08 }
            // n = 7, score = 100
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   8b0c90               | mov                 ecx, dword ptr [eax + edx*4]
            //   6bc918               | imul                ecx, ecx, 0x18
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   8b0c08               | mov                 ecx, dword ptr [eax + ecx]

        $sequence_4 = { 8b55fc 52 e8???????? 83c408 8945f8 817df8ce030000 7739 }
            // n = 7, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   817df8ce030000       | cmp                 dword ptr [ebp - 8], 0x3ce
            //   7739                 | ja                  0x3b

        $sequence_5 = { 8bca 81e10000f000 81f900004000 56 57 7f6c 7455 }
            // n = 7, score = 100
            //   8bca                 | mov                 ecx, edx
            //   81e10000f000         | and                 ecx, 0xf00000
            //   81f900004000         | cmp                 ecx, 0x400000
            //   56                   | push                esi
            //   57                   | push                edi
            //   7f6c                 | jg                  0x6e
            //   7455                 | je                  0x57

        $sequence_6 = { e9???????? e8???????? 85c0 747d 8b442418 8b4c2414 830b02 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   747d                 | je                  0x7f
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   830b02               | or                  dword ptr [ebx], 2

        $sequence_7 = { e8???????? 8945b0 8b4db0 898d30ffffff 8d9530ffffff 52 8b8decfeffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax
            //   8b4db0               | mov                 ecx, dword ptr [ebp - 0x50]
            //   898d30ffffff         | mov                 dword ptr [ebp - 0xd0], ecx
            //   8d9530ffffff         | lea                 edx, [ebp - 0xd0]
            //   52                   | push                edx
            //   8b8decfeffff         | mov                 ecx, dword ptr [ebp - 0x114]

        $sequence_8 = { 8b8d9cfeffff 8b511c 52 8b8580feffff 50 8b4d08 51 }
            // n = 7, score = 100
            //   8b8d9cfeffff         | mov                 ecx, dword ptr [ebp - 0x164]
            //   8b511c               | mov                 edx, dword ptr [ecx + 0x1c]
            //   52                   | push                edx
            //   8b8580feffff         | mov                 eax, dword ptr [ebp - 0x180]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx

        $sequence_9 = { 8bd3 8b32 3b31 7512 83e804 83c104 83c204 }
            // n = 7, score = 100
            //   8bd3                 | mov                 edx, ebx
            //   8b32                 | mov                 esi, dword ptr [edx]
            //   3b31                 | cmp                 esi, dword ptr [ecx]
            //   7512                 | jne                 0x14
            //   83e804               | sub                 eax, 4
            //   83c104               | add                 ecx, 4
            //   83c204               | add                 edx, 4

    condition:
        7 of them and filesize < 2859008
}