rule win_screencap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.screencap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.screencap"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4c2444 4183ec28 894804 8b4c2448 488bf8 6689580c }
            // n = 6, score = 100
            //   8b4c2444             | mov                 dword ptr [esp + 0x20], ebp
            //   4183ec28             | test                eax, eax
            //   894804               | inc                 esp
            //   8b4c2448             | mov                 eax, esi
            //   488bf8               | inc                 esp
            //   6689580c             | sub                 eax, eax

        $sequence_1 = { 4c8d0dee6d0100 4c8d0567120100 ba00080000 488bc8 48c744242000000000 e8???????? 85c0 }
            // n = 7, score = 100
            //   4c8d0dee6d0100       | push                ebx
            //   4c8d0567120100       | push                esi
            //   ba00080000           | push                edi
            //   488bc8               | inc                 ebp
            //   48c744242000000000     | hlt    
            //   e8????????           |                     
            //   85c0                 | mov                 esi, eax

        $sequence_2 = { d1f8 7423 66837c46fe5c 741b 403bc5 7316 }
            // n = 6, score = 100
            //   d1f8                 | test                esi, esi
            //   7423                 | dec                 eax
            //   66837c46fe5c         | add                 esp, 0x40
            //   741b                 | pop                 ebx
            //   403bc5               | ret                 
            //   7316                 | inc                 ecx

        $sequence_3 = { 488bc8 4c8be0 ff15???????? 488b15???????? 33c0 }
            // n = 5, score = 100
            //   488bc8               | inc                 ebp
            //   4c8be0               | xor                 eax, eax
            //   ff15????????         |                     
            //   488b15????????       |                     
            //   33c0                 | jmp                 0x164d

        $sequence_4 = { 488d0da7e70000 488b0cc1 44897c2444 4c8b7c2460 498b0c0f 4c8d4c2448 }
            // n = 6, score = 100
            //   488d0da7e70000       | test                eax, eax
            //   488b0cc1             | je                  0x200e
            //   44897c2444           | dec                 ecx
            //   4c8b7c2460           | mov                 ecx, edi
            //   498b0c0f             | dec                 eax
            //   4c8d4c2448           | mov                 ecx, eax

        $sequence_5 = { 418d4b06 410fb7c3 44895d0c 4c895d04 66f3ab 488d3ddebb0000 }
            // n = 6, score = 100
            //   418d4b06             | cwde                
            //   410fb7c3             | dec                 ebp
            //   44895d0c             | cmp                 ecx, esi
            //   4c895d04             | jne                 0x1017
            //   66f3ab               | movzx               eax, byte ptr [edi + ebx]
            //   488d3ddebb0000       | add                 eax, -0x2b

        $sequence_6 = { 7406 484a85c0 7fcc 66892c57 }
            // n = 4, score = 100
            //   7406                 | dec                 esp
            //   484a85c0             | mov                 dword ptr [ebp - 0x11], ebx
            //   7fcc                 | dec                 eax
            //   66892c57             | lea                 edx, [0xcb68]

        $sequence_7 = { 488d152ccb0000 e9???????? 488d1510cb0000 eb7c 488d15f7ca0000 eb73 488d15deca0000 }
            // n = 7, score = 100
            //   488d152ccb0000       | and                 edx, 0x1f
            //   e9????????           |                     
            //   488d1510cb0000       | dec                 eax
            //   eb7c                 | sar                 eax, 5
            //   488d15f7ca0000       | jae                 0xd68
            //   eb73                 | dec                 eax
            //   488d15deca0000       | mov                 edi, ebx

        $sequence_8 = { 8b7214 3b7204 7204 33c0 }
            // n = 4, score = 100
            //   8b7214               | inc                 ecx
            //   3b7204               | and                 eax, 0x1f
            //   7204                 | dec                 esp
            //   33c0                 | arpl                dx, ax

        $sequence_9 = { 50 8b442438 4850 e8???????? 50 }
            // n = 5, score = 100
            //   50                   | dec                 eax
            //   8b442438             | mov                 ecx, dword ptr [ecx + eax*8]
            //   4850                 | inc                 esp
            //   e8????????           |                     
            //   50                   | mov                 eax, edi

    condition:
        7 of them and filesize < 1391616
}