rule win_sedll_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sedll."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sedll"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5d c20c00 8b4510 33d2 51 8910 }
            // n = 6, score = 200
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   33d2                 | xor                 edx, edx
            //   51                   | push                ecx
            //   8910                 | mov                 dword ptr [eax], edx

        $sequence_1 = { 8d4590 50 6a00 56 }
            // n = 4, score = 200
            //   8d4590               | lea                 eax, [ebp - 0x70]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_2 = { ff75fc ff15???????? 85f6 7508 }
            // n = 4, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   85f6                 | test                esi, esi
            //   7508                 | jne                 0xa

        $sequence_3 = { 53 668945f8 a1???????? 660fd645f0 56 8bf1 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   668945f8             | mov                 word ptr [ebp - 8], ax
            //   a1????????           |                     
            //   660fd645f0           | movq                qword ptr [ebp - 0x10], xmm0
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx

        $sequence_4 = { 83fb03 7d8b 8b55fc 2bd7 7463 0fb60f }
            // n = 6, score = 200
            //   83fb03               | cmp                 ebx, 3
            //   7d8b                 | jge                 0xffffff8d
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   2bd7                 | sub                 edx, edi
            //   7463                 | je                  0x65
            //   0fb60f               | movzx               ecx, byte ptr [edi]

        $sequence_5 = { 8b5d14 8bcb 57 e8???????? 8bf8 85ff }
            // n = 6, score = 200
            //   8b5d14               | mov                 ebx, dword ptr [ebp + 0x14]
            //   8bcb                 | mov                 ecx, ebx
            //   57                   | push                edi
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi

        $sequence_6 = { 8d857cfeffff 8955f0 6a00 50 }
            // n = 4, score = 200
            //   8d857cfeffff         | lea                 eax, [ebp - 0x184]
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_7 = { 8bf1 85c0 740a 50 }
            // n = 4, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   50                   | push                eax

        $sequence_8 = { e8???????? 83c40c 33ff 85db 0f8eca000000 8b45fc 8a0407 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33ff                 | xor                 edi, edi
            //   85db                 | test                ebx, ebx
            //   0f8eca000000         | jle                 0xd0
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8a0407               | mov                 al, byte ptr [edi + eax]

        $sequence_9 = { a1???????? 50 8b08 ff5104 33c0 5e 8be5 }
            // n = 7, score = 200
            //   a1????????           |                     
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5104               | call                dword ptr [ecx + 4]
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

    condition:
        7 of them and filesize < 65536
}