rule win_session_manager_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.session_manager."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.session_manager"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c89b888080000 4c89b890080000 4c89b898080000 4c89b8a0080000 4c89b8a8080000 4c89b8b0080000 }
            // n = 6, score = 100
            //   4c89b888080000       | test                ebx, ebx
            //   4c89b890080000       | dec                 esp
            //   4c89b898080000       | mov                 ecx, edi
            //   4c89b8a0080000       | mov                 edx, 1
            //   4c89b8a8080000       | inc                 ecx
            //   4c89b8b0080000       | mov                 eax, 0x400

        $sequence_1 = { 4c89b8001a0000 4c89b8081a0000 4c89b8101a0000 4c89b8181a0000 4c89b8201a0000 4c89b8281a0000 4c89b8301a0000 }
            // n = 7, score = 100
            //   4c89b8001a0000       | mov                 dword ptr [eax + 0x1050], edi
            //   4c89b8081a0000       | dec                 esp
            //   4c89b8101a0000       | mov                 dword ptr [eax + 0x1058], edi
            //   4c89b8181a0000       | dec                 esp
            //   4c89b8201a0000       | mov                 dword ptr [eax + 0x1060], edi
            //   4c89b8281a0000       | dec                 esp
            //   4c89b8301a0000       | mov                 dword ptr [eax + 0x1068], edi

        $sequence_2 = { 418be8 4c8d0d66a80000 8bda 4c8d0555a80000 488bf9 }
            // n = 5, score = 100
            //   418be8               | mov                 dword ptr [eax + 0x5a8], edi
            //   4c8d0d66a80000       | dec                 esp
            //   8bda                 | mov                 dword ptr [eax + 0x5b0], edi
            //   4c8d0555a80000       | dec                 esp
            //   488bf9               | mov                 dword ptr [eax + 0x5b8], edi

        $sequence_3 = { 488d5308 33c9 48890a 48894a08 488d4c2420 e8???????? 488d0542450100 }
            // n = 7, score = 100
            //   488d5308             | mov                 dword ptr [eax + 0x2148], edi
            //   33c9                 | dec                 esp
            //   48890a               | mov                 dword ptr [eax + 0x2150], edi
            //   48894a08             | dec                 esp
            //   488d4c2420           | mov                 dword ptr [eax + 0x2228], edi
            //   e8????????           |                     
            //   488d0542450100       | dec                 esp

        $sequence_4 = { 7473 4c8d15c2f6feff 4b8b84fa80850200 f644383848 7421 8a8c2488000000 }
            // n = 6, score = 100
            //   7473                 | inc                 ecx
            //   4c8d15c2f6feff       | mov                 ecx, 0xa
            //   4b8b84fa80850200     | dec                 esp
            //   f644383848           | lea                 edx, [0x17dab]
            //   7421                 | inc                 sp
            //   8a8c2488000000       | cmp                 dword ptr [esp + 0x80], ecx

        $sequence_5 = { 498b06 498bce ff5018 4c8b08 4533c0 488d15f71a0200 488bc8 }
            // n = 7, score = 100
            //   498b06               | dec                 esp
            //   498bce               | mov                 dword ptr [eax + 0xe60], edi
            //   ff5018               | dec                 esp
            //   4c8b08               | mov                 dword ptr [eax + 0xf38], edi
            //   4533c0               | dec                 esp
            //   488d15f71a0200       | mov                 dword ptr [eax + 0xf40], edi
            //   488bc8               | dec                 esp

        $sequence_6 = { 488bd1 488bc1 48c1f806 4c8d05f4970100 83e23f 48c1e206 498b04c0 }
            // n = 7, score = 100
            //   488bd1               | mov                 dword ptr [eax + 0x1608], edi
            //   488bc1               | dec                 esp
            //   48c1f806             | mov                 dword ptr [eax + 0x1610], edi
            //   4c8d05f4970100       | dec                 esp
            //   83e23f               | mov                 dword ptr [eax + 0x1618], edi
            //   48c1e206             | dec                 esp
            //   498b04c0             | mov                 dword ptr [eax + 0x1620], edi

        $sequence_7 = { 4c89b8481b0000 4c89b8501b0000 4c89b8581b0000 4c89b8601b0000 }
            // n = 4, score = 100
            //   4c89b8481b0000       | dec                 eax
            //   4c89b8501b0000       | lea                 ebx, [0x15b43]
            //   4c89b8581b0000       | dec                 eax
            //   4c89b8601b0000       | mov                 ecx, dword ptr [ebx]

        $sequence_8 = { 4c89b820220000 4c89b828220000 4c89b830220000 4c89b838220000 4c89b840220000 4c89b848220000 4c89b850220000 }
            // n = 7, score = 100
            //   4c89b820220000       | mov                 dword ptr [eax + 0x2180], edi
            //   4c89b828220000       | dec                 esp
            //   4c89b830220000       | mov                 dword ptr [eax + 0x2258], edi
            //   4c89b838220000       | dec                 esp
            //   4c89b840220000       | mov                 dword ptr [eax + 0x2260], edi
            //   4c89b848220000       | dec                 esp
            //   4c89b850220000       | mov                 dword ptr [eax + 0x2268], edi

        $sequence_9 = { 4c89b8781d0000 4c89b8801d0000 4c89b8881d0000 4c89b8901d0000 4c89b8981d0000 }
            // n = 5, score = 100
            //   4c89b8781d0000       | sub                 esp, 0x20
            //   4c89b8801d0000       | mov                 ebx, ecx
            //   4c89b8881d0000       | dec                 esp
            //   4c89b8901d0000       | lea                 ecx, [0x10921]
            //   4c89b8981d0000       | dec                 eax

    condition:
        7 of them and filesize < 372736
}