rule win_silentgh0st_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.silentgh0st."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.silentgh0st"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1f905 8b0c8d00c40e10 83e01f c1e006 8d440124 8b4d10 8a10 }
            // n = 7, score = 100
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d00c40e10       | mov                 ecx, dword ptr [ecx*4 + 0x100ec400]
            //   83e01f               | and                 eax, 0x1f
            //   c1e006               | shl                 eax, 6
            //   8d440124             | lea                 eax, [ecx + eax + 0x24]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8a10                 | mov                 dl, byte ptr [eax]

        $sequence_1 = { c3 b808000000 e8???????? 8b4c2418 33c0 85c9 0f8ee6000000 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   b808000000           | mov                 eax, 8
            //   e8????????           |                     
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   0f8ee6000000         | jle                 0xec

        $sequence_2 = { 3bc7 7432 ff7308 50 e8???????? ff33 e8???????? }
            // n = 7, score = 100
            //   3bc7                 | cmp                 eax, edi
            //   7432                 | je                  0x34
            //   ff7308               | push                dword ptr [ebx + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff33                 | push                dword ptr [ebx]
            //   e8????????           |                     

        $sequence_3 = { a801 752a 8b5500 57 52 e8???????? 83c408 }
            // n = 7, score = 100
            //   a801                 | test                al, 1
            //   752a                 | jne                 0x2c
            //   8b5500               | mov                 edx, dword ptr [ebp]
            //   57                   | push                edi
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_4 = { 8bc6 c1f805 8bfe 53 8d1c8500c40e10 8b03 83e71f }
            // n = 7, score = 100
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8bfe                 | mov                 edi, esi
            //   53                   | push                ebx
            //   8d1c8500c40e10       | lea                 ebx, [eax*4 + 0x100ec400]
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   83e71f               | and                 edi, 0x1f

        $sequence_5 = { e8???????? 83c408 85c0 0f8431020000 8b4c2440 8b06 8b9084000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f8431020000         | je                  0x237
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b9084000000         | mov                 edx, dword ptr [eax + 0x84]

        $sequence_6 = { 8d6f03 8d4e01 895c2420 c744242404000000 8d642400 8b5c2428 0fb61c03 }
            // n = 7, score = 100
            //   8d6f03               | lea                 ebp, [edi + 3]
            //   8d4e01               | lea                 ecx, [esi + 1]
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx
            //   c744242404000000     | mov                 dword ptr [esp + 0x24], 4
            //   8d642400             | lea                 esp, [esp]
            //   8b5c2428             | mov                 ebx, dword ptr [esp + 0x28]
            //   0fb61c03             | movzx               ebx, byte ptr [ebx + eax]

        $sequence_7 = { c3 55 8bec 833d????????00 7505 e8???????? 33c9 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   833d????????00       |                     
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx

        $sequence_8 = { 83c410 833d????????00 750a c705????????18f60c10 68cc000000 68???????? 6a02 }
            // n = 7, score = 100
            //   83c410               | add                 esp, 0x10
            //   833d????????00       |                     
            //   750a                 | jne                 0xc
            //   c705????????18f60c10     |     
            //   68cc000000           | push                0xcc
            //   68????????           |                     
            //   6a02                 | push                2

        $sequence_9 = { 7ccc 8b5c2408 85db 7409 56 57 6a03 }
            // n = 7, score = 100
            //   7ccc                 | jl                  0xffffffce
            //   8b5c2408             | mov                 ebx, dword ptr [esp + 8]
            //   85db                 | test                ebx, ebx
            //   7409                 | je                  0xb
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a03                 | push                3

    condition:
        7 of them and filesize < 2065408
}