rule win_siluhdur_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.siluhdur"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 657874 657269 7479 2e6661 7374 }
            // n = 5, score = 100
            //   657874               | js                  0x77
            //   657269               | jb                  0x6c
            //   7479                 | je                  0x7b
            //   2e6661               | popaw               
            //   7374                 | jae                 0x76

        $sequence_1 = { ba???????? e8???????? c7042494000000 54 e8???????? 85c0 7457 }
            // n = 7, score = 100
            //   ba????????           |                     
            //   e8????????           |                     
            //   c7042494000000       | mov                 dword ptr [esp], 0x94
            //   54                   | push                esp
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7457                 | je                  0x59

        $sequence_2 = { 8bc8 41 b8???????? ba01000000 }
            // n = 4, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   41                   | inc                 ecx
            //   b8????????           |                     
            //   ba01000000           | mov                 edx, 1

        $sequence_3 = { 0f8447010000 8b75fc 8d45e4 50 6aff 6a00 }
            // n = 6, score = 100
            //   0f8447010000         | je                  0x14d
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   6aff                 | push                -1
            //   6a00                 | push                0

        $sequence_4 = { 8d55dc e8???????? 8b55dc b8???????? e8???????? e8???????? 8bd0 }
            // n = 7, score = 100
            //   8d55dc               | lea                 edx, [ebp - 0x24]
            //   e8????????           |                     
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]
            //   b8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax

        $sequence_5 = { 81c404010000 5b c3 53 81c400ffffff 8bd8 6800010000 }
            // n = 7, score = 100
            //   81c404010000         | add                 esp, 0x104
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   81c400ffffff         | add                 esp, 0xffffff00
            //   8bd8                 | mov                 ebx, eax
            //   6800010000           | push                0x100

        $sequence_6 = { 8b8008000000 5a 59 e8???????? e8???????? 8b8008000000 80781000 }
            // n = 7, score = 100
            //   8b8008000000         | mov                 eax, dword ptr [eax + 8]
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   e8????????           |                     
            //   8b8008000000         | mov                 eax, dword ptr [eax + 8]
            //   80781000             | cmp                 byte ptr [eax + 0x10], 0

        $sequence_7 = { e8???????? 85c0 7e27 8d45e0 50 8d45dc e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7e27                 | jle                 0x29
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   e8????????           |                     

        $sequence_8 = { b902000000 ba???????? 8b45f8 e8???????? 8b55e0 }
            // n = 5, score = 100
            //   b902000000           | mov                 ecx, 2
            //   ba????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e8????????           |                     
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]

        $sequence_9 = { 8b8008000000 80781000 7413 e8???????? }
            // n = 4, score = 100
            //   8b8008000000         | mov                 eax, dword ptr [eax + 8]
            //   80781000             | cmp                 byte ptr [eax + 0x10], 0
            //   7413                 | je                  0x15
            //   e8????????           |                     

    condition:
        7 of them and filesize < 180224
}