rule win_skyplex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.skyplex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.skyplex"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7458 8b8df4feffff 51 ff15???????? c785f0feffff00000000 eb0f 8b95f0feffff }
            // n = 7, score = 100
            //   7458                 | je                  0x5a
            //   8b8df4feffff         | mov                 ecx, dword ptr [ebp - 0x10c]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   c785f0feffff00000000     | mov    dword ptr [ebp - 0x110], 0
            //   eb0f                 | jmp                 0x11
            //   8b95f0feffff         | mov                 edx, dword ptr [ebp - 0x110]

        $sequence_1 = { 7510 6a00 68???????? ff15???????? 8945fc 837dfc00 }
            // n = 6, score = 100
            //   7510                 | jne                 0x12
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0

        $sequence_2 = { 83c408 e9???????? 68???????? 8d9538f7ffff 52 e8???????? }
            // n = 6, score = 100
            //   83c408               | add                 esp, 8
            //   e9????????           |                     
            //   68????????           |                     
            //   8d9538f7ffff         | lea                 edx, [ebp - 0x8c8]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_3 = { 7504 b001 eb4f ebc1 c785ecfeffff00000000 eb0f }
            // n = 6, score = 100
            //   7504                 | jne                 6
            //   b001                 | mov                 al, 1
            //   eb4f                 | jmp                 0x51
            //   ebc1                 | jmp                 0xffffffc3
            //   c785ecfeffff00000000     | mov    dword ptr [ebp - 0x114], 0
            //   eb0f                 | jmp                 0x11

        $sequence_4 = { 33c0 668945f8 8d4df8 51 }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   668945f8             | mov                 word ptr [ebp - 8], ax
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx

        $sequence_5 = { e8???????? 50 8d4d0c e8???????? 50 8b4de4 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]

        $sequence_6 = { ff15???????? 83c410 c78560f6ffff00000000 eb0f 8b8560f6ffff 83c001 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   c78560f6ffff00000000     | mov    dword ptr [ebp - 0x9a0], 0
            //   eb0f                 | jmp                 0x11
            //   8b8560f6ffff         | mov                 eax, dword ptr [ebp - 0x9a0]
            //   83c001               | add                 eax, 1

        $sequence_7 = { 83c408 85c0 7478 68???????? 8d8538f7ffff 50 }
            // n = 6, score = 100
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7478                 | je                  0x7a
            //   68????????           |                     
            //   8d8538f7ffff         | lea                 eax, [ebp - 0x8c8]
            //   50                   | push                eax

        $sequence_8 = { 8b45f4 50 ff15???????? 8945f0 6a00 }
            // n = 5, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   6a00                 | push                0

        $sequence_9 = { 6a01 ff15???????? c78544f6ffff01000000 eb0f 8b8d44f6ffff 83c101 898d44f6ffff }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   c78544f6ffff01000000     | mov    dword ptr [ebp - 0x9bc], 1
            //   eb0f                 | jmp                 0x11
            //   8b8d44f6ffff         | mov                 ecx, dword ptr [ebp - 0x9bc]
            //   83c101               | add                 ecx, 1
            //   898d44f6ffff         | mov                 dword ptr [ebp - 0x9bc], ecx

    condition:
        7 of them and filesize < 262144
}