rule win_slickshoes_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.slickshoes."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slickshoes"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b976b1d971 60 f9 66b884f9 61 668bf8 6681ef5cec }
            // n = 7, score = 100
            //   b976b1d971           | mov                 ecx, 0x71d9b176
            //   60                   | pushal              
            //   f9                   | stc                 
            //   66b884f9             | mov                 ax, 0xf984
            //   61                   | popal               
            //   668bf8               | mov                 di, ax
            //   6681ef5cec           | sub                 di, 0xec5c

        $sequence_1 = { ff3424 5d 57 89e7 81c704000000 83c704 57 }
            // n = 7, score = 100
            //   ff3424               | push                dword ptr [esp]
            //   5d                   | pop                 ebp
            //   57                   | push                edi
            //   89e7                 | mov                 edi, esp
            //   81c704000000         | add                 edi, 4
            //   83c704               | add                 edi, 4
            //   57                   | push                edi

        $sequence_2 = { ff3424 8b1c24 83c404 56 890424 54 58 }
            // n = 7, score = 100
            //   ff3424               | push                dword ptr [esp]
            //   8b1c24               | mov                 ebx, dword ptr [esp]
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   890424               | mov                 dword ptr [esp], eax
            //   54                   | push                esp
            //   58                   | pop                 eax

        $sequence_3 = { e9???????? 21d8 e9???????? 813424e58bf74a e9???????? 5d 81c35678f537 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   21d8                 | and                 eax, ebx
            //   e9????????           |                     
            //   813424e58bf74a       | xor                 dword ptr [esp], 0x4af78be5
            //   e9????????           |                     
            //   5d                   | pop                 ebp
            //   81c35678f537         | add                 ebx, 0x37f57856

        $sequence_4 = { e9???????? 81c404000000 e9???????? 890c24 50 c70424fddfed59 892c24 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   81c404000000         | add                 esp, 4
            //   e9????????           |                     
            //   890c24               | mov                 dword ptr [esp], ecx
            //   50                   | push                eax
            //   c70424fddfed59       | mov                 dword ptr [esp], 0x59eddffd
            //   892c24               | mov                 dword ptr [esp], ebp

        $sequence_5 = { be00040000 bf0a000000 8913 be00040000 09fe 89fe 81ce00040000 }
            // n = 7, score = 100
            //   be00040000           | mov                 esi, 0x400
            //   bf0a000000           | mov                 edi, 0xa
            //   8913                 | mov                 dword ptr [ebx], edx
            //   be00040000           | mov                 esi, 0x400
            //   09fe                 | or                  esi, edi
            //   89fe                 | mov                 esi, edi
            //   81ce00040000         | or                  esi, 0x400

        $sequence_6 = { e9???????? ba2682ff7f 53 bb15b4fb3a 81c3b5b7ff7d e9???????? 56 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   ba2682ff7f           | mov                 edx, 0x7fff8226
            //   53                   | push                ebx
            //   bb15b4fb3a           | mov                 ebx, 0x3afbb415
            //   81c3b5b7ff7d         | add                 ebx, 0x7dffb7b5
            //   e9????????           |                     
            //   56                   | push                esi

        $sequence_7 = { e9???????? c1e708 e9???????? 89df e9???????? 59 50 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c1e708               | shl                 edi, 8
            //   e9????????           |                     
            //   89df                 | mov                 edi, ebx
            //   e9????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax

        $sequence_8 = { 9d 7c77 52 c199????????f3 30e3 61 d6 }
            // n = 7, score = 100
            //   9d                   | popfd               
            //   7c77                 | jl                  0x79
            //   52                   | push                edx
            //   c199????????f3       |                     
            //   30e3                 | xor                 bl, ah
            //   61                   | popal               
            //   d6                   | salc                

        $sequence_9 = { e9???????? 313c24 333c24 e9???????? 870c24 8b2424 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   313c24               | xor                 dword ptr [esp], edi
            //   333c24               | xor                 edi, dword ptr [esp]
            //   e9????????           |                     
            //   870c24               | xchg                dword ptr [esp], ecx
            //   8b2424               | mov                 esp, dword ptr [esp]
            //   e9????????           |                     

    condition:
        7 of them and filesize < 11198464
}