rule win_slothfulmedia_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.slothfulmedia."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slothfulmedia"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3b45ec 0f82e5feffff 8b4508 53 56 }
            // n = 5, score = 200
            //   3b45ec               | cmp                 eax, dword ptr [ebp - 0x14]
            //   0f82e5feffff         | jb                  0xfffffeeb
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_1 = { 8d4dec 51 6a58 ffd0 6683bde0fdffff5c 0f8587000000 be???????? }
            // n = 7, score = 200
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   51                   | push                ecx
            //   6a58                 | push                0x58
            //   ffd0                 | call                eax
            //   6683bde0fdffff5c     | cmp                 word ptr [ebp - 0x220], 0x5c
            //   0f8587000000         | jne                 0x8d
            //   be????????           |                     

        $sequence_2 = { eb28 8b4f10 8bf0 6bf614 8d45fc 50 33c0 }
            // n = 7, score = 200
            //   eb28                 | jmp                 0x2a
            //   8b4f10               | mov                 ecx, dword ptr [edi + 0x10]
            //   8bf0                 | mov                 esi, eax
            //   6bf614               | imul                esi, esi, 0x14
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { eb65 53 8b1b ff15???????? 59 3bdf }
            // n = 6, score = 200
            //   eb65                 | jmp                 0x67
            //   53                   | push                ebx
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   3bdf                 | cmp                 ebx, edi

        $sequence_4 = { 33db 895de4 8d7de8 ab ab ab 33c0 }
            // n = 7, score = 200
            //   33db                 | xor                 ebx, ebx
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   8d7de8               | lea                 edi, [ebp - 0x18]
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { f3a6 750b 66ff45f8 66837df85a 72ae }
            // n = 5, score = 200
            //   f3a6                 | repe cmpsb          byte ptr [esi], byte ptr es:[edi]
            //   750b                 | jne                 0xd
            //   66ff45f8             | inc                 word ptr [ebp - 8]
            //   66837df85a           | cmp                 word ptr [ebp - 8], 0x5a
            //   72ae                 | jb                  0xffffffb0

        $sequence_6 = { 59 8b45f8 6a01 03c0 50 ff75fc }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   6a01                 | push                1
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_7 = { 53 ff15???????? 59 ff75f8 ffd7 59 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ffd7                 | call                edi
            //   59                   | pop                 ecx

        $sequence_8 = { 8d54240c 6a00 52 e8???????? 83c40c 6804010000 8d44240c }
            // n = 7, score = 100
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   6a00                 | push                0
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6804010000           | push                0x104
            //   8d44240c             | lea                 eax, [esp + 0xc]

        $sequence_9 = { 6a00 ff15???????? 8b35???????? 8b3d???????? 90 68???????? }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   8b3d????????         |                     
            //   90                   | nop                 
            //   68????????           |                     

        $sequence_10 = { 85c0 7507 ffd7 83f805 74ee 6804010000 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   ffd7                 | call                edi
            //   83f805               | cmp                 eax, 5
            //   74ee                 | je                  0xfffffff0
            //   6804010000           | push                0x104

        $sequence_11 = { 90 68???????? ffd6 85c0 7507 ffd7 }
            // n = 6, score = 100
            //   90                   | nop                 
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   ffd7                 | call                edi

        $sequence_12 = { 81ec0c020000 a1???????? 33c4 89842408020000 56 57 68d0070000 }
            // n = 7, score = 100
            //   81ec0c020000         | sub                 esp, 0x20c
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   89842408020000       | mov                 dword ptr [esp + 0x208], eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   68d0070000           | push                0x7d0

        $sequence_13 = { 6804010000 8d54240c 6a00 52 }
            // n = 4, score = 100
            //   6804010000           | push                0x104
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   6a00                 | push                0
            //   52                   | push                edx

        $sequence_14 = { 33cc 33c0 e8???????? 81c40c020000 }
            // n = 4, score = 100
            //   33cc                 | xor                 ecx, esp
            //   33c0                 | xor                 eax, eax
            //   e8????????           |                     
            //   81c40c020000         | add                 esp, 0x20c

        $sequence_15 = { 6689442414 e8???????? 83c40c 6a00 ff15???????? 8b35???????? }
            // n = 6, score = 100
            //   6689442414           | mov                 word ptr [esp + 0x14], ax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b35????????         |                     

    condition:
        7 of them and filesize < 122880
}