rule win_smrss32_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.smrss32"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 89442434 e9???????? e8???????? e8???????? 38d8 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   e9????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   38d8                 | cmp                 al, bl

        $sequence_1 = { e8???????? 89b585680000 6884ef314f e8???????? 8d442428 8974244c 96 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89b585680000         | mov                 dword ptr [ebp + 0x6885], esi
            //   6884ef314f           | push                0x4f31ef84
            //   e8????????           |                     
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   8974244c             | mov                 dword ptr [esp + 0x4c], esi
            //   96                   | xchg                eax, esi

        $sequence_2 = { 56 648b1530000000 85d2 782c 40 4e b46a }
            // n = 7, score = 100
            //   56                   | push                esi
            //   648b1530000000       | mov                 edx, dword ptr fs:[0x30]
            //   85d2                 | test                edx, edx
            //   782c                 | js                  0x2e
            //   40                   | inc                 eax
            //   4e                   | dec                 esi
            //   b46a                 | mov                 ah, 0x6a

        $sequence_3 = { 8f461c c746140c000000 8d8563ffffff 50 897618 806e02fc 6a04 }
            // n = 7, score = 100
            //   8f461c               | pop                 dword ptr [esi + 0x1c]
            //   c746140c000000       | mov                 dword ptr [esi + 0x14], 0xc
            //   8d8563ffffff         | lea                 eax, [ebp - 0x9d]
            //   50                   | push                eax
            //   897618               | mov                 dword ptr [esi + 0x18], esi
            //   806e02fc             | sub                 byte ptr [esi + 2], 0xfc
            //   6a04                 | push                4

        $sequence_4 = { ffd7 ff542450 fe0c24 75f2 87d7 f6d6 58 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   ff542450             | call                dword ptr [esp + 0x50]
            //   fe0c24               | dec                 byte ptr [esp]
            //   75f2                 | jne                 0xfffffff4
            //   87d7                 | xchg                edi, edx
            //   f6d6                 | not                 dh
            //   58                   | pop                 eax

        $sequence_5 = { 8bfe 6a04 59 58 ab 48 }
            // n = 6, score = 100
            //   8bfe                 | mov                 edi, esi
            //   6a04                 | push                4
            //   59                   | pop                 ecx
            //   58                   | pop                 eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   48                   | dec                 eax

        $sequence_6 = { e8???????? 89442434 e9???????? e8???????? e8???????? 38d8 7509 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   e9????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   38d8                 | cmp                 al, bl
            //   7509                 | jne                 0xb

        $sequence_7 = { 49 68d67d53f3 e8???????? 89742444 }
            // n = 4, score = 100
            //   49                   | dec                 ecx
            //   68d67d53f3           | push                0xf3537dd6
            //   e8????????           |                     
            //   89742444             | mov                 dword ptr [esp + 0x44], esi

        $sequence_8 = { ff857d680000 ff542458 54 ff54245c }
            // n = 4, score = 100
            //   ff857d680000         | inc                 dword ptr [ebp + 0x687d]
            //   ff542458             | call                dword ptr [esp + 0x58]
            //   54                   | push                esp
            //   ff54245c             | call                dword ptr [esp + 0x5c]

        $sequence_9 = { 47 96 3400 e8???????? }
            // n = 4, score = 100
            //   47                   | inc                 edi
            //   96                   | xchg                eax, esi
            //   3400                 | xor                 al, 0
            //   e8????????           |                     

    condition:
        7 of them and filesize < 427008
}