rule win_socksbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.socksbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.socksbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b750c 33ff 57 57 6a01 57 }
            // n = 6, score = 300
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   6a01                 | push                1
            //   57                   | push                edi

        $sequence_1 = { ff15???????? 50 8945fc ff15???????? 8bd8 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_2 = { 85c0 0f8488000000 03c7 8945f0 }
            // n = 4, score = 300
            //   85c0                 | test                eax, eax
            //   0f8488000000         | je                  0x8e
            //   03c7                 | add                 eax, edi
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_3 = { ff15???????? 8bd0 33c9 85d2 7e22 53 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   33c9                 | xor                 ecx, ecx
            //   85d2                 | test                edx, edx
            //   7e22                 | jle                 0x24
            //   53                   | push                ebx

        $sequence_4 = { 0f8e22010000 6a20 57 c6043e00 e8???????? 59 }
            // n = 6, score = 300
            //   0f8e22010000         | jle                 0x128
            //   6a20                 | push                0x20
            //   57                   | push                edi
            //   c6043e00             | mov                 byte ptr [esi + edi], 0
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_5 = { 754f 0fb67304 56 8d4305 50 8d85f0feffff }
            // n = 6, score = 300
            //   754f                 | jne                 0x51
            //   0fb67304             | movzx               esi, byte ptr [ebx + 4]
            //   56                   | push                esi
            //   8d4305               | lea                 eax, [ebx + 5]
            //   50                   | push                eax
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]

        $sequence_6 = { 50 e8???????? 83c40c 84c0 0f8485000000 6800040000 e8???????? }
            // n = 7, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   84c0                 | test                al, al
            //   0f8485000000         | je                  0x8b
            //   6800040000           | push                0x400
            //   e8????????           |                     

        $sequence_7 = { ff758c e8???????? 8bd8 59 85db 7441 8b4dfc }
            // n = 7, score = 300
            //   ff758c               | push                dword ptr [ebp - 0x74]
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   59                   | pop                 ecx
            //   85db                 | test                ebx, ebx
            //   7441                 | je                  0x43
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_8 = { 8b75fc 53 ff15???????? 57 e8???????? }
            // n = 5, score = 300
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_9 = { 8d4609 50 8d4508 50 e8???????? 83c40c 8b7dfc }
            // n = 7, score = 300
            //   8d4609               | lea                 eax, [esi + 9]
            //   50                   | push                eax
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 73728
}