rule win_spider_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.spider_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spider_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8d0513ca0600 83e21f 486bd258 490314c8 488d0d414b0600 eb11 488d0d384b0600 }
            // n = 7, score = 200
            //   4c8d0513ca0600       | mov                 dword ptr [ecx], eax
            //   83e21f               | dec                 eax
            //   486bd258             | mov                 ecx, dword ptr [ecx + 0x50]
            //   490314c8             | dec                 eax
            //   488d0d414b0600       | test                ecx, ecx
            //   eb11                 | inc                 eax
            //   488d0d384b0600       | push                ebx

        $sequence_1 = { 48898424d0000000 488bc2 488bf9 488364242800 488d2d2bc80100 48896c2420 }
            // n = 6, score = 200
            //   48898424d0000000     | sub                 ecx, dword ptr [eax - 8]
            //   488bc2               | mov                 ebp, dword ptr [eax - 0x10]
            //   488bf9               | dec                 esp
            //   488364242800         | sub                 esp, eax
            //   488d2d2bc80100       | mov                 eax, dword ptr [eax - 0xc]
            //   48896c2420           | sub                 eax, ebx

        $sequence_2 = { 488d8c2480000000 e8???????? 90 4c8d842448010000 488bd0 488d8c24d0000000 e8???????? }
            // n = 7, score = 200
            //   488d8c2480000000     | cmp                 dword ptr [esp + 0x38], ebx
            //   e8????????           |                     
            //   90                   | jne                 0x182
            //   4c8d842448010000     | je                  0x203
            //   488bd0               | xor                 esi, esi
            //   488d8c24d0000000     | inc                 esp
            //   e8????????           |                     

        $sequence_3 = { 0fbe1401 488d1c01 488d0db7b30500 4d8bc1 e8???????? 4885c0 752e }
            // n = 7, score = 200
            //   0fbe1401             | dec                 eax
            //   488d1c01             | lea                 ecx, [eax + 0x10]
            //   488d0db7b30500       | dec                 eax
            //   4d8bc1               | mov                 dword ptr [esp + 0x20], 0xfffffffe
            //   e8????????           |                     
            //   4885c0               | dec                 eax
            //   752e                 | mov                 ebx, ecx

        $sequence_4 = { 8bd7 e8???????? 90 4889442450 488d15d3c50200 488d4c2450 }
            // n = 6, score = 200
            //   8bd7                 | mov                 ebx, dword ptr [esp + 0x40]
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   4889442450           | mov                 ecx, ebx
            //   488d15d3c50200       | cmp                 dword ptr [ebx + 0x10], 0
            //   488d4c2450           | jne                 0xdaa

        $sequence_5 = { 488b8b48020000 4c8d8c24d0040000 488d9424d0000000 4183c8ff 896c2420 ff15???????? 85c0 }
            // n = 7, score = 200
            //   488b8b48020000       | dec                 eax
            //   4c8d8c24d0040000     | or                  ecx, 0xffffffff
            //   488d9424d0000000     | dec                 eax
            //   4183c8ff             | lea                 edi, [esp + 0x510]
            //   896c2420             | xor                 eax, eax
            //   ff15????????         |                     
            //   85c0                 | dec                 eax

        $sequence_6 = { 4885db 74f1 488b02 488364243800 4c8d442438 488d154f380200 498bc9 }
            // n = 7, score = 200
            //   4885db               | dec                 eax
            //   74f1                 | mov                 esi, dword ptr [esp + 0x40]
            //   488b02               | dec                 eax
            //   488364243800         | mov                 edi, dword ptr [esp + 0x48]
            //   4c8d442438           | jl                  0x3a6
            //   488d154f380200       | jmp                 0x3f1
            //   498bc9               | dec                 eax

        $sequence_7 = { 488d2df4890500 e9???????? bf58000000 488bd7 448d67a9 498bcc e8???????? }
            // n = 7, score = 200
            //   488d2df4890500       | dec                 eax
            //   e9????????           |                     
            //   bf58000000           | mov                 ecx, dword ptr [esp + 0x150]
            //   488bd7               | dec                 eax
            //   448d67a9             | xor                 ecx, esp
            //   498bcc               | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 53 4883ec30 48c7442420feffffff 488bd9 488d05df650300 488901 }
            // n = 6, score = 200
            //   53                   | dec                 ecx
            //   4883ec30             | arpl                ax, bx
            //   48c7442420feffffff     | dec    eax
            //   488bd9               | mov                 esi, edx
            //   488d05df650300       | dec                 eax
            //   488901               | mov                 dword ptr [eax + 0x18], esi

        $sequence_9 = { 740d 4183e5fd 488bcb ff15???????? 4084ed 0f85da000000 488b8c24a8000000 }
            // n = 7, score = 200
            //   740d                 | dec                 eax
            //   4183e5fd             | add                 ecx, dword ptr [ebp + 0x18]
            //   488bcb               | dec                 esp
            //   ff15????????         |                     
            //   4084ed               | cmp                 esi, ecx
            //   0f85da000000         | jb                  0x17e4
            //   488b8c24a8000000     | dec                 esp

    condition:
        7 of them and filesize < 1107968
}