rule win_spybot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.spybot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spybot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 50 57 e8???????? 59 50 ff7518 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   ff7518               | push                dword ptr [ebp + 0x18]

        $sequence_1 = { 3bc7 7309 83ffff 0f8599080000 53 e8???????? 59 }
            // n = 7, score = 100
            //   3bc7                 | cmp                 eax, edi
            //   7309                 | jae                 0xb
            //   83ffff               | cmp                 edi, -1
            //   0f8599080000         | jne                 0x89f
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_2 = { f7f1 8bd8 ff15???????? ff75e4 e8???????? 3975c8 }
            // n = 6, score = 100
            //   f7f1                 | div                 ecx
            //   8bd8                 | mov                 ebx, eax
            //   ff15????????         |                     
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   3975c8               | cmp                 dword ptr [ebp - 0x38], esi

        $sequence_3 = { 83c624 3b7dfc 0f8c66ffffff 395df8 0f8512ffffff ff75f4 }
            // n = 6, score = 100
            //   83c624               | add                 esi, 0x24
            //   3b7dfc               | cmp                 edi, dword ptr [ebp - 4]
            //   0f8c66ffffff         | jl                  0xffffff6c
            //   395df8               | cmp                 dword ptr [ebp - 8], ebx
            //   0f8512ffffff         | jne                 0xffffff18
            //   ff75f4               | push                dword ptr [ebp - 0xc]

        $sequence_4 = { 0f85a6000000 80fb41 0f849d000000 0fbef3 56 68???????? 8d45ec }
            // n = 7, score = 100
            //   0f85a6000000         | jne                 0xac
            //   80fb41               | cmp                 bl, 0x41
            //   0f849d000000         | je                  0xa3
            //   0fbef3               | movsx               esi, bl
            //   56                   | push                esi
            //   68????????           |                     
            //   8d45ec               | lea                 eax, [ebp - 0x14]

        $sequence_5 = { ff15???????? ff75d2 ff15???????? 8945fc 8d8520feffff 50 897508 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   ff75d2               | push                dword ptr [ebp - 0x2e]
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8d8520feffff         | lea                 eax, [ebp - 0x1e0]
            //   50                   | push                eax
            //   897508               | mov                 dword ptr [ebp + 8], esi

        $sequence_6 = { 50 e8???????? 83c410 399d54ffffff 0f85a8faffff 53 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   399d54ffffff         | cmp                 dword ptr [ebp - 0xac], ebx
            //   0f85a8faffff         | jne                 0xfffffaae
            //   53                   | push                ebx

        $sequence_7 = { 7d1f 3c5d 741b 397dfc 7516 8b5d0c }
            // n = 6, score = 100
            //   7d1f                 | jge                 0x21
            //   3c5d                 | cmp                 al, 0x5d
            //   741b                 | je                  0x1d
            //   397dfc               | cmp                 dword ptr [ebp - 4], edi
            //   7516                 | jne                 0x18
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]

        $sequence_8 = { ffb43578ffffff 8d85f8f8ffff 68???????? 50 e8???????? ffb4357cffffff e8???????? }
            // n = 7, score = 100
            //   ffb43578ffffff       | push                dword ptr [ebp + esi - 0x88]
            //   8d85f8f8ffff         | lea                 eax, [ebp - 0x708]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   ffb4357cffffff       | push                dword ptr [ebp + esi - 0x84]
            //   e8????????           |                     

        $sequence_9 = { ff742414 56 ff742418 ff742418 e8???????? 83c414 56 }
            // n = 7, score = 100
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   56                   | push                esi
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   56                   | push                esi

    condition:
        7 of them and filesize < 2367488
}