rule win_startpage_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.startpage."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.startpage"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8455feffff 663906 7407 83c602 3bf3 75f4 3bf3 }
            // n = 7, score = 200
            //   0f8455feffff         | je                  0xfffffe5b
            //   663906               | cmp                 word ptr [esi], ax
            //   7407                 | je                  9
            //   83c602               | add                 esi, 2
            //   3bf3                 | cmp                 esi, ebx
            //   75f4                 | jne                 0xfffffff6
            //   3bf3                 | cmp                 esi, ebx

        $sequence_1 = { 59 85f6 746b ff75f0 6a00 56 e8???????? }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   85f6                 | test                esi, esi
            //   746b                 | je                  0x6d
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   6a00                 | push                0
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_2 = { 770f 8bc1 50 e8???????? 83c404 32c0 eb08 }
            // n = 7, score = 200
            //   770f                 | ja                  0x11
            //   8bc1                 | mov                 eax, ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   32c0                 | xor                 al, al
            //   eb08                 | jmp                 0xa

        $sequence_3 = { 8a430c 8a490c 88420c 8b55f0 884b0c 807b0c01 0f8530010000 }
            // n = 7, score = 200
            //   8a430c               | mov                 al, byte ptr [ebx + 0xc]
            //   8a490c               | mov                 cl, byte ptr [ecx + 0xc]
            //   88420c               | mov                 byte ptr [edx + 0xc], al
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   884b0c               | mov                 byte ptr [ebx + 0xc], cl
            //   807b0c01             | cmp                 byte ptr [ebx + 0xc], 1
            //   0f8530010000         | jne                 0x136

        $sequence_4 = { 85ff 7414 8bcf e8???????? 8bcf }
            // n = 5, score = 200
            //   85ff                 | test                edi, edi
            //   7414                 | je                  0x16
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8bcf                 | mov                 ecx, edi

        $sequence_5 = { e8???????? 50 8d8d90feffff e8???????? 46 3b7334 72e5 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d8d90feffff         | lea                 ecx, [ebp - 0x170]
            //   e8????????           |                     
            //   46                   | inc                 esi
            //   3b7334               | cmp                 esi, dword ptr [ebx + 0x34]
            //   72e5                 | jb                  0xffffffe7

        $sequence_6 = { 8bf9 8d7718 56 ff7704 ffd3 8d45ec 0f57c0 }
            // n = 7, score = 200
            //   8bf9                 | mov                 edi, ecx
            //   8d7718               | lea                 esi, [edi + 0x18]
            //   56                   | push                esi
            //   ff7704               | push                dword ptr [edi + 4]
            //   ffd3                 | call                ebx
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   0f57c0               | xorps               xmm0, xmm0

        $sequence_7 = { 85d2 7507 b803400080 eb47 8b450c 56 33f6 }
            // n = 7, score = 200
            //   85d2                 | test                edx, edx
            //   7507                 | jne                 9
            //   b803400080           | mov                 eax, 0x80004003
            //   eb47                 | jmp                 0x49
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi

        $sequence_8 = { 895dfc 895dd4 81fb80000000 7d4d 8b049da0974500 8945d8 85c0 }
            // n = 7, score = 200
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx
            //   81fb80000000         | cmp                 ebx, 0x80
            //   7d4d                 | jge                 0x4f
            //   8b049da0974500       | mov                 eax, dword ptr [ebx*4 + 0x4597a0]
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   85c0                 | test                eax, eax

        $sequence_9 = { 5b 8be5 5d c3 ff15???????? 0fb7c8 81c900000780 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   ff15????????         |                     
            //   0fb7c8               | movzx               ecx, ax
            //   81c900000780         | or                  ecx, 0x80070000

    condition:
        7 of them and filesize < 2277376
}