rule win_stowaway_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.stowaway."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stowaway"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a7cbe46 a3???????? 4e fb }
            // n = 4, score = 200
            //   8a7cbe46             | mov                 bh, byte ptr [esi + edi*4 + 0x46]
            //   a3????????           |                     
            //   4e                   | dec                 esi
            //   fb                   | sti                 

        $sequence_1 = { 4e fb b501 2a37 }
            // n = 4, score = 200
            //   4e                   | dec                 esi
            //   fb                   | sti                 
            //   b501                 | mov                 ch, 1
            //   2a37                 | sub                 dh, byte ptr [edi]

        $sequence_2 = { f67be8 7ce8 7de8 7ee8 }
            // n = 4, score = 200
            //   f67be8               | idiv                byte ptr [ebx - 0x18]
            //   7ce8                 | jl                  0xffffffea
            //   7de8                 | jge                 0xffffffea
            //   7ee8                 | jle                 0xffffffea

        $sequence_3 = { 76e8 77e8 78e8 79e8 }
            // n = 4, score = 200
            //   76e8                 | jbe                 0xffffffea
            //   77e8                 | ja                  0xffffffea
            //   78e8                 | js                  0xffffffea
            //   79e8                 | jns                 0xffffffea

        $sequence_4 = { 78e8 79e8 7ae8 ce f67be8 7ce8 }
            // n = 6, score = 200
            //   78e8                 | js                  0xffffffea
            //   79e8                 | jns                 0xffffffea
            //   7ae8                 | jp                  0xffffffea
            //   ce                   | into                
            //   f67be8               | idiv                byte ptr [ebx - 0x18]
            //   7ce8                 | jl                  0xffffffea

        $sequence_5 = { 182e 087c1013 181c04 a6 }
            // n = 4, score = 100
            //   182e                 | sbb                 byte ptr [esi], ch
            //   087c1013             | or                  byte ptr [eax + edx + 0x13], bh
            //   181c04               | sbb                 byte ptr [esp + eax], bl
            //   a6                   | cmpsb               byte ptr [esi], byte ptr es:[edi]

        $sequence_6 = { 3f 68fe260c00 5a 3cc3 }
            // n = 4, score = 100
            //   3f                   | aas                 
            //   68fe260c00           | push                0xc26fe
            //   5a                   | pop                 edx
            //   3cc3                 | cmp                 al, 0xc3

        $sequence_7 = { 7277 d7 c9 2127 }
            // n = 4, score = 100
            //   7277                 | jb                  0x79
            //   d7                   | xlatb               
            //   c9                   | leave               
            //   2127                 | and                 dword ptr [edi], esp

        $sequence_8 = { 322c0d01123df8 16 e0ff 2e1c43 1c56 186111 040f }
            // n = 7, score = 100
            //   322c0d01123df8       | xor                 ch, byte ptr [ecx - 0x7c2edff]
            //   16                   | push                ss
            //   e0ff                 | loopne              1
            //   2e1c43               | sbb                 al, 0x43
            //   1c56                 | sbb                 al, 0x56
            //   186111               | sbb                 byte ptr [ecx + 0x11], ah
            //   040f                 | add                 al, 0xf

        $sequence_9 = { 89f9 57 48 f2ae 55 ff9630a03b00 09c0 }
            // n = 7, score = 100
            //   89f9                 | mov                 ecx, edi
            //   57                   | push                edi
            //   48                   | dec                 eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   55                   | push                ebp
            //   ff9630a03b00         | call                dword ptr [esi + 0x3ba030]
            //   09c0                 | or                  eax, eax

        $sequence_10 = { 66790d 93 265e 27 }
            // n = 4, score = 100
            //   66790d               | jns                 0x10
            //   93                   | xchg                eax, ebx
            //   265e                 | pop                 esi
            //   27                   | daa                 

        $sequence_11 = { b423 53 e774 5b 004f49 5c 7221 }
            // n = 7, score = 100
            //   b423                 | mov                 ah, 0x23
            //   53                   | push                ebx
            //   e774                 | out                 0x74, eax
            //   5b                   | pop                 ebx
            //   004f49               | add                 byte ptr [edi + 0x49], cl
            //   5c                   | pop                 esp
            //   7221                 | jb                  0x23

        $sequence_12 = { 40 3b740282 f4 d6 2a09 }
            // n = 5, score = 100
            //   40                   | inc                 eax
            //   3b740282             | cmp                 esi, dword ptr [edx + eax - 0x7e]
            //   f4                   | hlt                 
            //   d6                   | salc                
            //   2a09                 | sub                 cl, byte ptr [ecx]

        $sequence_13 = { 0c3f 090448 b8f58621b0 0448 }
            // n = 4, score = 100
            //   0c3f                 | or                  al, 0x3f
            //   090448               | or                  dword ptr [eax + ecx*2], eax
            //   b8f58621b0           | mov                 eax, 0xb02186f5
            //   0448                 | add                 al, 0x48

        $sequence_14 = { 58 c8737282 fc fc 91 }
            // n = 5, score = 100
            //   58                   | pop                 eax
            //   c8737282             | enter               0x7273, -0x7e
            //   fc                   | cld                 
            //   fc                   | cld                 
            //   91                   | xchg                eax, ecx

        $sequence_15 = { e6a0 2ea4 0e 0cef 30e5 46 }
            // n = 6, score = 100
            //   e6a0                 | out                 0xa0, al
            //   2ea4                 | movsb               byte ptr es:[edi], byte ptr cs:[esi]
            //   0e                   | push                cs
            //   0cef                 | or                  al, 0xef
            //   30e5                 | xor                 ch, ah
            //   46                   | inc                 esi

        $sequence_16 = { 56 a8b4 c8a03b0a a1???????? }
            // n = 4, score = 100
            //   56                   | push                esi
            //   a8b4                 | test                al, 0xb4
            //   c8a03b0a             | enter               0x3ba0, 0xa
            //   a1????????           |                     

        $sequence_17 = { 52 1d1af29c20 3ca4 5b }
            // n = 4, score = 100
            //   52                   | push                edx
            //   1d1af29c20           | sbb                 eax, 0x209cf21a
            //   3ca4                 | cmp                 al, 0xa4
            //   5b                   | pop                 ebx

        $sequence_18 = { 7783 7786 7787 7788 }
            // n = 4, score = 100
            //   7783                 | ja                  0xffffff85
            //   7786                 | ja                  0xffffff88
            //   7787                 | ja                  0xffffff89
            //   7788                 | ja                  0xffffff8a

    condition:
        7 of them and filesize < 8003584
}