rule win_subzero_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.subzero."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.subzero"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf0 85c0 781f 488b4c2450 488b01 4c8d442468 488d1561850400 }
            // n = 7, score = 100
            //   8bf0                 | dec                 eax
            //   85c0                 | mov                 ecx, edi
            //   781f                 | nop                 dword ptr [eax + eax]
            //   488b4c2450           | inc                 ebp
            //   488b01               | mov                 ecx, ebp
            //   4c8d442468           | dec                 eax
            //   488d1561850400       | mov                 dword ptr [ebp + 0x50], eax

        $sequence_1 = { e9???????? ba80090000 e9???????? 4c89642440 488b11 488b4210 ff15???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   ba80090000           | dec                 eax
            //   e9????????           |                     
            //   4c89642440           | mov                 eax, dword ptr [ecx]
            //   488b11               | movsd               xmm3, qword ptr [ebp - 0x28]
            //   488b4210             | movsd               xmm2, qword ptr [ebp - 0x30]
            //   ff15????????         |                     

        $sequence_2 = { e8???????? 85c0 7534 488d15d7060500 e8???????? 85c0 744f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | mov                 eax, dword ptr [ebp + 0x48]
            //   7534                 | cmp                 eax, 0xe06d7363
            //   488d15d7060500       | jne                 0x1df1
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   744f                 | mov                 edx, dword ptr [ebp + 0xd8]

        $sequence_3 = { 53 56 57 4883ec20 49832100 4c8d4010 498bf1 }
            // n = 7, score = 100
            //   53                   | jne                 0xcfa
            //   56                   | dec                 eax
            //   57                   | mov                 ecx, dword ptr [ebp - 0x10]
            //   4883ec20             | inc                 esp
            //   49832100             | cmp                 dword ptr [edi + 0x5a8], esi
            //   4c8d4010             | jne                 0x399d7
            //   498bf1               | cmp                 esi, dword ptr [edi + 0x5a0]

        $sequence_4 = { e8???????? 84c0 7473 837e28fd 746d 488d4c2440 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | mov                 dword ptr [ebp + 0x98], eax
            //   7473                 | mov                 byte ptr [ebp + 0xa0], 0
            //   837e28fd             | dec                 eax
            //   746d                 | mov                 eax, dword ptr [esp + 0x38]
            //   488d4c2440           | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { e9???????? 4c8bc8 4c3b5020 7308 41b001 488b00 eb07 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4c8bc8               | mov                 eax, dword ptr [eax + 0x30]
            //   4c3b5020             | mov                 ebx, eax
            //   7308                 | test                eax, eax
            //   41b001               | dec                 eax
            //   488b00               | mov                 eax, dword ptr [ecx]
            //   eb07                 | dec                 esp

        $sequence_6 = { b900000080 8bf8 03c1 85c1 7508 81ff7a000780 7551 }
            // n = 7, score = 100
            //   b900000080           | mov                 edi, ecx
            //   8bf8                 | dec                 eax
            //   03c1                 | test                edx, edx
            //   85c1                 | jne                 0xca3
            //   7508                 | dec                 eax
            //   81ff7a000780         | mov                 dword ptr [eax + 8], ebx
            //   7551                 | dec                 eax

        $sequence_7 = { 48897020 488b05???????? 4833c4 4889442478 488bf9 4533ed 4438a938020000 }
            // n = 7, score = 100
            //   48897020             | mov                 dword ptr [ebx + 0x10], 0
            //   488b05????????       |                     
            //   4833c4               | mov                 edi, edx
            //   4889442478           | dec                 eax
            //   488bf9               | mov                 ebx, ecx
            //   4533ed               | dec                 eax
            //   4438a938020000       | mov                 ecx, dword ptr [ecx + 0x18]

        $sequence_8 = { ff15???????? 4c897d07 488b4d0f 488b01 488d5507 488b4020 ff15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4c897d07             | lea                 edi, [ecx + 0x32c]
            //   488b4d0f             | dec                 ecx
            //   488b01               | mov                 ecx, edi
            //   488d5507             | nop                 dword ptr [eax + eax]
            //   488b4020             | test                eax, eax
            //   ff15????????         |                     

        $sequence_9 = { 7506 4883c750 eb02 33ff e8???????? 488d15c9aeffff e8???????? }
            // n = 7, score = 100
            //   7506                 | mov                 dword ptr [esp + 0x40], 0x208
            //   4883c750             | dec                 eax
            //   eb02                 | mov                 dword ptr [esp + 0x30], eax
            //   33ff                 | inc                 esp
            //   e8????????           |                     
            //   488d15c9aeffff       | lea                 ecx, [ebx + 2]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1420288
}