rule win_sysraw_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sysraw_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sysraw_stealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff5208 8b4510 8b8d7cffffff 8908 8b45fc 8b4dec }
            // n = 6, score = 700
            //   ff5208               | call                dword ptr [edx + 8]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b8d7cffffff         | mov                 ecx, dword ptr [ebp - 0x84]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]

        $sequence_1 = { 8d9504ffffff 8d8508ffffff 52 8d8d0cffffff }
            // n = 4, score = 700
            //   8d9504ffffff         | lea                 edx, [ebp - 0xfc]
            //   8d8508ffffff         | lea                 eax, [ebp - 0xf8]
            //   52                   | push                edx
            //   8d8d0cffffff         | lea                 ecx, [ebp - 0xf4]

        $sequence_2 = { 8d4db8 ff15???????? 8b0b 8d55a4 }
            // n = 4, score = 700
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   ff15????????         |                     
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   8d55a4               | lea                 edx, [ebp - 0x5c]

        $sequence_3 = { 6a03 8d55a4 68???????? 52 897de0 89bd7cffffff }
            // n = 6, score = 700
            //   6a03                 | push                3
            //   8d55a4               | lea                 edx, [ebp - 0x5c]
            //   68????????           |                     
            //   52                   | push                edx
            //   897de0               | mov                 dword ptr [ebp - 0x20], edi
            //   89bd7cffffff         | mov                 dword ptr [ebp - 0x84], edi

        $sequence_4 = { 8d8d54ffffff 50 8d9558ffffff 51 8d855cffffff 52 8d8d60ffffff }
            // n = 7, score = 700
            //   8d8d54ffffff         | lea                 ecx, [ebp - 0xac]
            //   50                   | push                eax
            //   8d9558ffffff         | lea                 edx, [ebp - 0xa8]
            //   51                   | push                ecx
            //   8d855cffffff         | lea                 eax, [ebp - 0xa4]
            //   52                   | push                edx
            //   8d8d60ffffff         | lea                 ecx, [ebp - 0xa0]

        $sequence_5 = { 8b00 50 6a01 ff15???????? 56 8945cc }
            // n = 6, score = 700
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   56                   | push                esi
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax

        $sequence_6 = { 8945ec e9???????? 6683fe1f 751d 8b4d0c 68???????? }
            // n = 6, score = 700
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   e9????????           |                     
            //   6683fe1f             | cmp                 si, 0x1f
            //   751d                 | jne                 0x1f
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   68????????           |                     

        $sequence_7 = { 2bc7 8d4da4 c1e003 51 50 6880000000 53 }
            // n = 7, score = 700
            //   2bc7                 | sub                 eax, edi
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]
            //   c1e003               | shl                 eax, 3
            //   51                   | push                ecx
            //   50                   | push                eax
            //   6880000000           | push                0x80
            //   53                   | push                ebx

        $sequence_8 = { 8b5004 894ddc 8b4808 894dd0 8b4814 }
            // n = 5, score = 700
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   894dd0               | mov                 dword ptr [ebp - 0x30], ecx
            //   8b4814               | mov                 ecx, dword ptr [eax + 0x14]

        $sequence_9 = { ff15???????? 0faff7 0375cc 81e60f000080 }
            // n = 4, score = 700
            //   ff15????????         |                     
            //   0faff7               | imul                esi, edi
            //   0375cc               | add                 esi, dword ptr [ebp - 0x34]
            //   81e60f000080         | and                 esi, 0x8000000f

    condition:
        7 of them and filesize < 1540096
}