rule win_systembc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.systembc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.systembc"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 53 57 56 8b7d10 }
            // n = 5, score = 1100
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]

        $sequence_1 = { 7507 66837fff00 740d 837d1000 7409 66837aff00 7502 }
            // n = 7, score = 1100
            //   7507                 | jne                 9
            //   66837fff00           | cmp                 word ptr [edi - 1], 0
            //   740d                 | je                  0xf
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7409                 | je                  0xb
            //   66837aff00           | cmp                 word ptr [edx - 1], 0
            //   7502                 | jne                 4

        $sequence_2 = { 8b4d0c 837d0c00 750b ff7508 e8???????? }
            // n = 5, score = 1100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   750b                 | jne                 0xd
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_3 = { 837d0cfe 751c 837d1000 7507 66837fff00 }
            // n = 5, score = 1100
            //   837d0cfe             | cmp                 dword ptr [ebp + 0xc], -2
            //   751c                 | jne                 0x1e
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7507                 | jne                 9
            //   66837fff00           | cmp                 word ptr [edi - 1], 0

        $sequence_4 = { 50 8b45f8 8b08 50 8b4178 }
            // n = 5, score = 1100
            //   50                   | push                eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   8b4178               | mov                 eax, dword ptr [ecx + 0x78]

        $sequence_5 = { 6a00 8d85fcfbffff 50 8b45f8 8b08 }
            // n = 5, score = 1100
            //   6a00                 | push                0
            //   8d85fcfbffff         | lea                 eax, [ebp - 0x404]
            //   50                   | push                eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_6 = { 740d 837d1000 7409 66837aff00 7502 eb2e }
            // n = 6, score = 1100
            //   740d                 | je                  0xf
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7409                 | je                  0xb
            //   66837aff00           | cmp                 word ptr [edx - 1], 0
            //   7502                 | jne                 4
            //   eb2e                 | jmp                 0x30

        $sequence_7 = { 837d0cfe 751c 837d1000 7507 66837fff00 740d 837d1000 }
            // n = 7, score = 1100
            //   837d0cfe             | cmp                 dword ptr [ebp + 0xc], -2
            //   751c                 | jne                 0x1e
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7507                 | jne                 9
            //   66837fff00           | cmp                 word ptr [edi - 1], 0
            //   740d                 | je                  0xf
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0

        $sequence_8 = { c9 c21400 55 8bec 53 57 56 }
            // n = 7, score = 1100
            //   c9                   | leave               
            //   c21400               | ret                 0x14
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_9 = { 8b450c ab 8b4514 ab }
            // n = 4, score = 1100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   ab                   | stosd               dword ptr es:[edi], eax

    condition:
        7 of them and filesize < 75776
}