rule win_tarsip_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tarsip."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tarsip"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 899c2464420100 899c2468420100 8d442410 50 899c2484420100 e8???????? }
            // n = 6, score = 100
            //   899c2464420100       | mov                 dword ptr [esp + 0x14264], ebx
            //   899c2468420100       | mov                 dword ptr [esp + 0x14268], ebx
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   899c2484420100       | mov                 dword ptr [esp + 0x14284], ebx
            //   e8????????           |                     

        $sequence_1 = { bdc40f0000 897c240c 393e 0f868d010000 53 }
            // n = 5, score = 100
            //   bdc40f0000           | mov                 ebp, 0xfc4
            //   897c240c             | mov                 dword ptr [esp + 0xc], edi
            //   393e                 | cmp                 dword ptr [esi], edi
            //   0f868d010000         | jbe                 0x193
            //   53                   | push                ebx

        $sequence_2 = { 52 ba???????? 8bcf e8???????? 8d8424ac000000 50 e8???????? }
            // n = 7, score = 100
            //   52                   | push                edx
            //   ba????????           |                     
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8d8424ac000000       | lea                 eax, [esp + 0xac]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 889c24c8020000 e8???????? 8b35???????? 83c40c 6804010000 8d8424c0020000 50 }
            // n = 7, score = 100
            //   889c24c8020000       | mov                 byte ptr [esp + 0x2c8], bl
            //   e8????????           |                     
            //   8b35????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6804010000           | push                0x104
            //   8d8424c0020000       | lea                 eax, [esp + 0x2c0]
            //   50                   | push                eax

        $sequence_4 = { 8d4c2414 68???????? 51 e8???????? 8b8618420100 83c41c 68000000a0 }
            // n = 7, score = 100
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b8618420100         | mov                 eax, dword ptr [esi + 0x14218]
            //   83c41c               | add                 esp, 0x1c
            //   68000000a0           | push                0xa0000000

        $sequence_5 = { 8b442410 50 e8???????? 83c404 b801000000 8b8c242c010000 64890d00000000 }
            // n = 7, score = 100
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   b801000000           | mov                 eax, 1
            //   8b8c242c010000       | mov                 ecx, dword ptr [esp + 0x12c]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_6 = { 53 55 57 33db 8d8e907e0000 bd73020000 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   8d8e907e0000         | lea                 ecx, [esi + 0x7e90]
            //   bd73020000           | mov                 ebp, 0x273

        $sequence_7 = { eb6d 8b3f ebdc 8b8424ac000000 50 55 }
            // n = 6, score = 100
            //   eb6d                 | jmp                 0x6f
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   ebdc                 | jmp                 0xffffffde
            //   8b8424ac000000       | mov                 eax, dword ptr [esp + 0xac]
            //   50                   | push                eax
            //   55                   | push                ebp

        $sequence_8 = { c78424c8070000ffffffff c74424700f000000 895c246c 885c245c 39b4248c000000 720d 8b4c2478 }
            // n = 7, score = 100
            //   c78424c8070000ffffffff     | mov    dword ptr [esp + 0x7c8], 0xffffffff
            //   c74424700f000000     | mov                 dword ptr [esp + 0x70], 0xf
            //   895c246c             | mov                 dword ptr [esp + 0x6c], ebx
            //   885c245c             | mov                 byte ptr [esp + 0x5c], bl
            //   39b4248c000000       | cmp                 dword ptr [esp + 0x8c], esi
            //   720d                 | jb                  0xf
            //   8b4c2478             | mov                 ecx, dword ptr [esp + 0x78]

        $sequence_9 = { 52 e8???????? 83c414 eb10 6a0a 8d542404 52 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   eb10                 | jmp                 0x12
            //   6a0a                 | push                0xa
            //   8d542404             | lea                 edx, [esp + 4]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 360448
}