rule win_tclient_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tclient."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tclient"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 757b 8b4d10 c701a0010000 8b4d14 c70140000000 eb67 }
            // n = 6, score = 100
            //   757b                 | jne                 0x7d
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   c701a0010000         | mov                 dword ptr [ecx], 0x1a0
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   c70140000000         | mov                 dword ptr [ecx], 0x40
            //   eb67                 | jmp                 0x69

        $sequence_1 = { 03c1 3bc3 0f8fdf010000 8b5df0 0fb6041a 66c1e008 0fb7c8 }
            // n = 7, score = 100
            //   03c1                 | add                 eax, ecx
            //   3bc3                 | cmp                 eax, ebx
            //   0f8fdf010000         | jg                  0x1e5
            //   8b5df0               | mov                 ebx, dword ptr [ebp - 0x10]
            //   0fb6041a             | movzx               eax, byte ptr [edx + ebx]
            //   66c1e008             | shl                 ax, 8
            //   0fb7c8               | movzx               ecx, ax

        $sequence_2 = { e8???????? 8d4598 8bce 50 e8???????? 57 6a01 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4598               | lea                 eax, [ebp - 0x68]
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   57                   | push                edi
            //   6a01                 | push                1

        $sequence_3 = { 0f85cc010000 8b450c 8b4d9c c1e003 3bc1 7613 83e107 }
            // n = 7, score = 100
            //   0f85cc010000         | jne                 0x1d2
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   c1e003               | shl                 eax, 3
            //   3bc1                 | cmp                 eax, ecx
            //   7613                 | jbe                 0x15
            //   83e107               | and                 ecx, 7

        $sequence_4 = { 85f6 75e3 8bc1 3bd8 740f 8bd1 8bcb }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   75e3                 | jne                 0xffffffe5
            //   8bc1                 | mov                 eax, ecx
            //   3bd8                 | cmp                 ebx, eax
            //   740f                 | je                  0x11
            //   8bd1                 | mov                 edx, ecx
            //   8bcb                 | mov                 ecx, ebx

        $sequence_5 = { 83f802 7443 83f803 747a bf40ffffff 83ff94 7578 }
            // n = 7, score = 100
            //   83f802               | cmp                 eax, 2
            //   7443                 | je                  0x45
            //   83f803               | cmp                 eax, 3
            //   747a                 | je                  0x7c
            //   bf40ffffff           | mov                 edi, 0xffffff40
            //   83ff94               | cmp                 edi, -0x6c
            //   7578                 | jne                 0x7a

        $sequence_6 = { 2bc7 7417 83e801 742f 83e801 }
            // n = 5, score = 100
            //   2bc7                 | sub                 eax, edi
            //   7417                 | je                  0x19
            //   83e801               | sub                 eax, 1
            //   742f                 | je                  0x31
            //   83e801               | sub                 eax, 1

        $sequence_7 = { c645fc04 8d4d94 8b45e0 83c018 50 e8???????? 6800040000 }
            // n = 7, score = 100
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8d4d94               | lea                 ecx, [ebp - 0x6c]
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   83c018               | add                 eax, 0x18
            //   50                   | push                eax
            //   e8????????           |                     
            //   6800040000           | push                0x400

        $sequence_8 = { c21800 b8???????? e8???????? 81ec38040000 53 56 57 }
            // n = 7, score = 100
            //   c21800               | ret                 0x18
            //   b8????????           |                     
            //   e8????????           |                     
            //   81ec38040000         | sub                 esp, 0x438
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_9 = { 56 e8???????? 59 59 c70602000000 eb14 83660800 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   c70602000000         | mov                 dword ptr [esi], 2
            //   eb14                 | jmp                 0x16
            //   83660800             | and                 dword ptr [esi + 8], 0

    condition:
        7 of them and filesize < 1063936
}