rule win_teleport_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.teleport."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.teleport"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 330c8560ba4200 0fb6c2 8b55f4 330c8560b64200 334f30 }
            // n = 5, score = 100
            //   330c8560ba4200       | xor                 ecx, dword ptr [eax*4 + 0x42ba60]
            //   0fb6c2               | movzx               eax, dl
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   330c8560b64200       | xor                 ecx, dword ptr [eax*4 + 0x42b660]
            //   334f30               | xor                 ecx, dword ptr [edi + 0x30]

        $sequence_1 = { c1e810 33148da0e24200 8b4df8 0fb6c0 }
            // n = 4, score = 100
            //   c1e810               | shr                 eax, 0x10
            //   33148da0e24200       | xor                 edx, dword ptr [ecx*4 + 0x42e2a0]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   0fb6c0               | movzx               eax, al

        $sequence_2 = { 75f5 2bcf d1f9 7429 8bca 8d4102 8985ccf7ffff }
            // n = 7, score = 100
            //   75f5                 | jne                 0xfffffff7
            //   2bcf                 | sub                 ecx, edi
            //   d1f9                 | sar                 ecx, 1
            //   7429                 | je                  0x2b
            //   8bca                 | mov                 ecx, edx
            //   8d4102               | lea                 eax, [ecx + 2]
            //   8985ccf7ffff         | mov                 dword ptr [ebp - 0x834], eax

        $sequence_3 = { 8b4df4 c1e918 331485a0fa4200 8b45fc 0fb6c0 331485a0f64200 339774ffffff }
            // n = 7, score = 100
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   c1e918               | shr                 ecx, 0x18
            //   331485a0fa4200       | xor                 edx, dword ptr [eax*4 + 0x42faa0]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0fb6c0               | movzx               eax, al
            //   331485a0f64200       | xor                 edx, dword ptr [eax*4 + 0x42f6a0]
            //   339774ffffff         | xor                 edx, dword ptr [edi - 0x8c]

        $sequence_4 = { 3041ff 83ea01 75f2 eb0d 0f100f 0f1003 660fefc8 }
            // n = 7, score = 100
            //   3041ff               | xor                 byte ptr [ecx - 1], al
            //   83ea01               | sub                 edx, 1
            //   75f2                 | jne                 0xfffffff4
            //   eb0d                 | jmp                 0xf
            //   0f100f               | movups              xmm1, xmmword ptr [edi]
            //   0f1003               | movups              xmm0, xmmword ptr [ebx]
            //   660fefc8             | pxor                xmm1, xmm0

        $sequence_5 = { 660fd60f 8d7f08 8b048d841c4100 ffe0 f7c703000000 7413 8a06 }
            // n = 7, score = 100
            //   660fd60f             | movq                qword ptr [edi], xmm1
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048d841c4100       | mov                 eax, dword ptr [ecx*4 + 0x411c84]
            //   ffe0                 | jmp                 eax
            //   f7c703000000         | test                edi, 3
            //   7413                 | je                  0x15
            //   8a06                 | mov                 al, byte ptr [esi]

        $sequence_6 = { 8bca c1e918 8bc2 8b0c8d60c24200 c1e810 0fb6c0 330c8560be4200 }
            // n = 7, score = 100
            //   8bca                 | mov                 ecx, edx
            //   c1e918               | shr                 ecx, 0x18
            //   8bc2                 | mov                 eax, edx
            //   8b0c8d60c24200       | mov                 ecx, dword ptr [ecx*4 + 0x42c260]
            //   c1e810               | shr                 eax, 0x10
            //   0fb6c0               | movzx               eax, al
            //   330c8560be4200       | xor                 ecx, dword ptr [eax*4 + 0x42be60]

        $sequence_7 = { 8b8514feffff 83c840 8d8d00feffff c645fc0a 83c808 eb54 c785f0fdffff80b54200 }
            // n = 7, score = 100
            //   8b8514feffff         | mov                 eax, dword ptr [ebp - 0x1ec]
            //   83c840               | or                  eax, 0x40
            //   8d8d00feffff         | lea                 ecx, [ebp - 0x200]
            //   c645fc0a             | mov                 byte ptr [ebp - 4], 0xa
            //   83c808               | or                  eax, 8
            //   eb54                 | jmp                 0x56
            //   c785f0fdffff80b54200     | mov    dword ptr [ebp - 0x210], 0x42b580

        $sequence_8 = { 8a87fc314300 08441619 42 0fb64101 3bd0 76e5 }
            // n = 6, score = 100
            //   8a87fc314300         | mov                 al, byte ptr [edi + 0x4331fc]
            //   08441619             | or                  byte ptr [esi + edx + 0x19], al
            //   42                   | inc                 edx
            //   0fb64101             | movzx               eax, byte ptr [ecx + 1]
            //   3bd0                 | cmp                 edx, eax
            //   76e5                 | jbe                 0xffffffe7

        $sequence_9 = { 52 8b01 8b4010 ffd0 84c0 747e 68???????? }
            // n = 7, score = 100
            //   52                   | push                edx
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   ffd0                 | call                eax
            //   84c0                 | test                al, al
            //   747e                 | je                  0x80
            //   68????????           |                     

    condition:
        7 of them and filesize < 458752
}