rule win_termite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.termite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.termite"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945f0 8b45f0 3b4510 7426 837df000 }
            // n = 5, score = 200
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   3b4510               | cmp                 eax, dword ptr [ebp + 0x10]
            //   7426                 | je                  0x28
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0

        $sequence_1 = { 89e5 837d0800 740a 8b4508 8b4010 85c0 7507 }
            // n = 7, score = 200
            //   89e5                 | mov                 ebp, esp
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   740a                 | je                  0xc
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9

        $sequence_2 = { c745f001000000 837d08ff 750a b8ffffffff e9???????? c785ecfeffff00000000 c745f400000000 }
            // n = 7, score = 200
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   837d08ff             | cmp                 dword ptr [ebp + 8], -1
            //   750a                 | jne                 0xc
            //   b8ffffffff           | mov                 eax, 0xffffffff
            //   e9????????           |                     
            //   c785ecfeffff00000000     | mov    dword ptr [ebp - 0x114], 0
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0

        $sequence_3 = { c1e002 05???????? 8b00 8945e0 8b55e4 89d0 c1e002 }
            // n = 7, score = 200
            //   c1e002               | shl                 eax, 2
            //   05????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   89d0                 | mov                 eax, edx
            //   c1e002               | shl                 eax, 2

        $sequence_4 = { c745f000000000 eb46 8b4508 8b5010 8b45f0 6bc074 01d0 }
            // n = 7, score = 200
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   eb46                 | jmp                 0x48
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b5010               | mov                 edx, dword ptr [eax + 0x10]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   6bc074               | imul                eax, eax, 0x74
            //   01d0                 | add                 eax, edx

        $sequence_5 = { 8b45ec 8b55f0 83c210 89442408 89542404 }
            // n = 5, score = 200
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   83c210               | add                 edx, 0x10
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   89542404             | mov                 dword ptr [esp + 4], edx

        $sequence_6 = { 85c0 7432 8b4510 8d48ff 8b4508 8b4008 8b10 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7432                 | je                  0x34
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   8b10                 | mov                 edx, dword ptr [eax]

        $sequence_7 = { c9 c3 55 89e5 83ec28 c745f400000000 c744240804000000 }
            // n = 7, score = 200
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   83ec28               | sub                 esp, 0x28
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   c744240804000000     | mov                 dword ptr [esp + 8], 4

        $sequence_8 = { 8b4508 8b4004 8d5001 8b4508 895004 8b45f0 8945ec }
            // n = 7, score = 200
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   8d5001               | lea                 edx, [eax + 1]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_9 = { 8b45f0 89442404 8b4508 890424 e8???????? 8945e8 8b450c }
            // n = 7, score = 200
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 312320
}