rule win_thanatos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.thanatos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.thanatos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 668945f8 a0???????? 8845fa 8d45f4 50 ff15???????? }
            // n = 6, score = 500
            //   668945f8             | mov                 word ptr [ebp - 8], ax
            //   a0????????           |                     
            //   8845fa               | mov                 byte ptr [ebp - 6], al
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { 8d45f0 50 ff15???????? 8bf0 ba3c9a4d59 }
            // n = 5, score = 500
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   ba3c9a4d59           | mov                 edx, 0x594d9a3c

        $sequence_2 = { 50 ff15???????? 8d45c8 8945e4 8d45e0 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]

        $sequence_3 = { 53 8d85e4fdffff 50 e8???????? 83f801 b9???????? }
            // n = 6, score = 500
            //   53                   | push                ebx
            //   8d85e4fdffff         | lea                 eax, [ebp - 0x21c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83f801               | cmp                 eax, 1
            //   b9????????           |                     

        $sequence_4 = { 884304 8d0c37 2bf1 8d43fb 03c6 8944241d c644241ce9 }
            // n = 7, score = 500
            //   884304               | mov                 byte ptr [ebx + 4], al
            //   8d0c37               | lea                 ecx, [edi + esi]
            //   2bf1                 | sub                 esi, ecx
            //   8d43fb               | lea                 eax, [ebx - 5]
            //   03c6                 | add                 eax, esi
            //   8944241d             | mov                 dword ptr [esp + 0x1d], eax
            //   c644241ce9           | mov                 byte ptr [esp + 0x1c], 0xe9

        $sequence_5 = { 83c108 8b45fc 5f ba40000000 5e }
            // n = 5, score = 500
            //   83c108               | add                 ecx, 8
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   ba40000000           | mov                 edx, 0x40
            //   5e                   | pop                 esi

        $sequence_6 = { 8985f0dfffff 3bc3 0f8541010000 85f6 }
            // n = 4, score = 500
            //   8985f0dfffff         | mov                 dword ptr [ebp - 0x2010], eax
            //   3bc3                 | cmp                 eax, ebx
            //   0f8541010000         | jne                 0x147
            //   85f6                 | test                esi, esi

        $sequence_7 = { 8d45bd 6a00 50 c645bc00 e8???????? 83c418 e8???????? }
            // n = 7, score = 500
            //   8d45bd               | lea                 eax, [ebp - 0x43]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c645bc00             | mov                 byte ptr [ebp - 0x44], 0
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   e8????????           |                     

        $sequence_8 = { b906000000 eb05 b907000000 8b55fc 668b044dc84f0210 8b4d10 52 }
            // n = 7, score = 500
            //   b906000000           | mov                 ecx, 6
            //   eb05                 | jmp                 7
            //   b907000000           | mov                 ecx, 7
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   668b044dc84f0210     | mov                 ax, word ptr [ecx*2 + 0x10024fc8]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   52                   | push                edx

        $sequence_9 = { 50 c745f45c400110 e8???????? cc 55 8bec }
            // n = 6, score = 500
            //   50                   | push                eax
            //   c745f45c400110       | mov                 dword ptr [ebp - 0xc], 0x1001405c
            //   e8????????           |                     
            //   cc                   | int3                
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

    condition:
        7 of them and filesize < 1810432
}