rule win_thanatos_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.thanatos_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.thanatos_ransom"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b0485e0774300 894df0 8a440129 8b4d08 8845ff }
            // n = 5, score = 100
            //   8b0485e0774300       | mov                 eax, dword ptr [eax*4 + 0x4377e0]
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8a440129             | mov                 al, byte ptr [ecx + eax + 0x29]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8845ff               | mov                 byte ptr [ebp - 1], al

        $sequence_1 = { e8???????? 3bf0 7419 4e }
            // n = 4, score = 100
            //   e8????????           |                     
            //   3bf0                 | cmp                 esi, eax
            //   7419                 | je                  0x1b
            //   4e                   | dec                 esi

        $sequence_2 = { e8???????? 83c404 c645fc0e 83781410 7202 8b00 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c645fc0e             | mov                 byte ptr [ebp - 4], 0xe
            //   83781410             | cmp                 dword ptr [eax + 0x14], 0x10
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_3 = { c644012801 8b0495e0774300 897c0118 8bfe e9???????? }
            // n = 5, score = 100
            //   c644012801           | mov                 byte ptr [ecx + eax + 0x28], 1
            //   8b0495e0774300       | mov                 eax, dword ptr [edx*4 + 0x4377e0]
            //   897c0118             | mov                 dword ptr [ecx + eax + 0x18], edi
            //   8bfe                 | mov                 edi, esi
            //   e9????????           |                     

        $sequence_4 = { e8???????? c645fc04 8b45d4 83f810 7242 8b4dc0 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   83f810               | cmp                 eax, 0x10
            //   7242                 | jb                  0x44
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]

        $sequence_5 = { e9???????? 8d8db8feffff e9???????? 8d8d70feffff e9???????? 8d8d88feffff }
            // n = 6, score = 100
            //   e9????????           |                     
            //   8d8db8feffff         | lea                 ecx, [ebp - 0x148]
            //   e9????????           |                     
            //   8d8d70feffff         | lea                 ecx, [ebp - 0x190]
            //   e9????????           |                     
            //   8d8d88feffff         | lea                 ecx, [ebp - 0x178]

        $sequence_6 = { ff15???????? 8b859cfeffff 83f810 7245 8b8d88feffff }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8b859cfeffff         | mov                 eax, dword ptr [ebp - 0x164]
            //   83f810               | cmp                 eax, 0x10
            //   7245                 | jb                  0x47
            //   8b8d88feffff         | mov                 ecx, dword ptr [ebp - 0x178]

        $sequence_7 = { 6a04 58 6bc000 8b4d08 898814714300 }
            // n = 5, score = 100
            //   6a04                 | push                4
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   898814714300         | mov                 dword ptr [eax + 0x437114], ecx

        $sequence_8 = { ff758c e8???????? 33c0 c745a007000000 c7459c00000000 6689458c 39856cffffff }
            // n = 7, score = 100
            //   ff758c               | push                dword ptr [ebp - 0x74]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c745a007000000       | mov                 dword ptr [ebp - 0x60], 7
            //   c7459c00000000       | mov                 dword ptr [ebp - 0x64], 0
            //   6689458c             | mov                 word ptr [ebp - 0x74], ax
            //   39856cffffff         | cmp                 dword ptr [ebp - 0x94], eax

        $sequence_9 = { 6af6 ff15???????? 8b04bde0774300 834c0318ff 33c0 }
            // n = 5, score = 100
            //   6af6                 | push                -0xa
            //   ff15????????         |                     
            //   8b04bde0774300       | mov                 eax, dword ptr [edi*4 + 0x4377e0]
            //   834c0318ff           | or                  dword ptr [ebx + eax + 0x18], 0xffffffff
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 516096
}