rule win_tidepool_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tidepool."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tidepool"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5e c20400 80790800 c701???????? 740e 8b4904 }
            // n = 6, score = 1000
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   80790800             | cmp                 byte ptr [ecx + 8], 0
            //   c701????????         |                     
            //   740e                 | je                  0x10
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]

        $sequence_1 = { 6a00 50 8b08 ff91a4000000 }
            // n = 4, score = 1000
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff91a4000000         | call                dword ptr [ecx + 0xa4]

        $sequence_2 = { 5b 8b8d00030000 33cd e8???????? 81c504030000 }
            // n = 5, score = 1000
            //   5b                   | pop                 ebx
            //   8b8d00030000         | mov                 ecx, dword ptr [ebp + 0x300]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   81c504030000         | add                 ebp, 0x304

        $sequence_3 = { e8???????? 83c404 8bc6 5e c20400 80790800 }
            // n = 6, score = 1000
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   80790800             | cmp                 byte ptr [ecx + 8], 0

        $sequence_4 = { 64890d00000000 59 5f 5e 5b 8b8d00030000 }
            // n = 6, score = 1000
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8b8d00030000         | mov                 ecx, dword ptr [ebp + 0x300]

        $sequence_5 = { 83e906 51 83c006 50 6a02 }
            // n = 5, score = 900
            //   83e906               | sub                 ecx, 6
            //   51                   | push                ecx
            //   83c006               | add                 eax, 6
            //   50                   | push                eax
            //   6a02                 | push                2

        $sequence_6 = { 6800000040 8d4500 50 ff15???????? }
            // n = 4, score = 900
            //   6800000040           | push                0x40000000
            //   8d4500               | lea                 eax, [ebp]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_7 = { 83c40c 803d????????37 7518 68???????? }
            // n = 4, score = 900
            //   83c40c               | add                 esp, 0xc
            //   803d????????37       |                     
            //   7518                 | jne                 0x1a
            //   68????????           |                     

        $sequence_8 = { 33db 53 6a02 8bf1 e8???????? }
            // n = 5, score = 900
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   6a02                 | push                2
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     

        $sequence_9 = { 8d5668 52 8d5658 52 50 ff91d0000000 33ff }
            // n = 7, score = 800
            //   8d5668               | lea                 edx, [esi + 0x68]
            //   52                   | push                edx
            //   8d5658               | lea                 edx, [esi + 0x58]
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff91d0000000         | call                dword ptr [ecx + 0xd0]
            //   33ff                 | xor                 edi, edi

        $sequence_10 = { 75f9 b8???????? b900000400 c60000 40 49 }
            // n = 6, score = 800
            //   75f9                 | jne                 0xfffffffb
            //   b8????????           |                     
            //   b900000400           | mov                 ecx, 0x40000
            //   c60000               | mov                 byte ptr [eax], 0
            //   40                   | inc                 eax
            //   49                   | dec                 ecx

        $sequence_11 = { 8b4654 8d9698000000 52 8d5678 }
            // n = 4, score = 800
            //   8b4654               | mov                 eax, dword ptr [esi + 0x54]
            //   8d9698000000         | lea                 edx, [esi + 0x98]
            //   52                   | push                edx
            //   8d5678               | lea                 edx, [esi + 0x78]

        $sequence_12 = { 50 8b08 ff5138 47 83ff14 }
            // n = 5, score = 800
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5138               | call                dword ptr [ecx + 0x38]
            //   47                   | inc                 edi
            //   83ff14               | cmp                 edi, 0x14

        $sequence_13 = { 8d45ec 50 681f000200 53 }
            // n = 4, score = 800
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   681f000200           | push                0x2001f
            //   53                   | push                ebx

        $sequence_14 = { 57 50 6802020000 ff15???????? 68???????? ff15???????? 8bf8 }
            // n = 7, score = 800
            //   57                   | push                edi
            //   50                   | push                eax
            //   6802020000           | push                0x202
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_15 = { c60000 40 49 75f9 b8???????? b900000400 }
            // n = 6, score = 800
            //   c60000               | mov                 byte ptr [eax], 0
            //   40                   | inc                 eax
            //   49                   | dec                 ecx
            //   75f9                 | jne                 0xfffffffb
            //   b8????????           |                     
            //   b900000400           | mov                 ecx, 0x40000

        $sequence_16 = { 6810270000 ff15???????? 8b45ec 8b08 }
            // n = 4, score = 800
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_17 = { 681f000200 56 68???????? 6801000080 }
            // n = 4, score = 800
            //   681f000200           | push                0x2001f
            //   56                   | push                esi
            //   68????????           |                     
            //   6801000080           | push                0x80000001

        $sequence_18 = { e8???????? 68???????? 68???????? 68???????? 8d4500 50 }
            // n = 6, score = 800
            //   e8????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   8d4500               | lea                 eax, [ebp]
            //   50                   | push                eax

        $sequence_19 = { c3 56 8bf1 e8???????? 8b4654 6a00 }
            // n = 6, score = 800
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   8b4654               | mov                 eax, dword ptr [esi + 0x54]
            //   6a00                 | push                0

        $sequence_20 = { 8be9 895c2418 0f8e62020000 83c0ff c1e802 }
            // n = 5, score = 600
            //   8be9                 | mov                 ebp, ecx
            //   895c2418             | mov                 dword ptr [esp + 0x18], ebx
            //   0f8e62020000         | jle                 0x268
            //   83c0ff               | add                 eax, -1
            //   c1e802               | shr                 eax, 2

        $sequence_21 = { ff75ec ff15???????? 8b35???????? 6a04 }
            // n = 4, score = 400
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   6a04                 | push                4

        $sequence_22 = { e8???????? 83c43c 8d45f8 50 683f000f00 53 ff75fc }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c43c               | add                 esp, 0x3c
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   683f000f00           | push                0xf003f
            //   53                   | push                ebx
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_23 = { 8d45fc 50 683f000f00 53 ff75f8 57 }
            // n = 6, score = 200
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   683f000f00           | push                0xf003f
            //   53                   | push                ebx
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   57                   | push                edi

        $sequence_24 = { b940000000 33c0 f2aa ff5614 6850010000 }
            // n = 5, score = 200
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   f2aa                 | repne stosb         byte ptr es:[edi], al
            //   ff5614               | call                dword ptr [esi + 0x14]
            //   6850010000           | push                0x150

        $sequence_25 = { ff75f4 ff75ec ffd7 56 53 }
            // n = 5, score = 200
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ffd7                 | call                edi
            //   56                   | push                esi
            //   53                   | push                ebx

        $sequence_26 = { 7505 83c8ff c9 c3 8b400c 8b00 }
            // n = 6, score = 200
            //   7505                 | jne                 7
            //   83c8ff               | or                  eax, 0xffffffff
            //   c9                   | leave               
            //   c3                   | ret                 
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_27 = { 8d043e 50 e8???????? 037dfc 8d45d8 }
            // n = 5, score = 200
            //   8d043e               | lea                 eax, [esi + edi]
            //   50                   | push                eax
            //   e8????????           |                     
            //   037dfc               | add                 edi, dword ptr [ebp - 4]
            //   8d45d8               | lea                 eax, [ebp - 0x28]

    condition:
        7 of them and filesize < 1998848
}