rule win_tofsee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tofsee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tofsee"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 55 8bec 6864006400 ff7514 ff15???????? }
            // n = 6, score = 400
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   6864006400           | push                0x640064
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff15????????         |                     

        $sequence_1 = { ff7508 8d45e4 50 e8???????? 85c0 59 59 }
            // n = 7, score = 400
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_2 = { 837f0800 7408 8b36 33ff 391e 75e1 85ff }
            // n = 7, score = 400
            //   837f0800             | cmp                 dword ptr [edi + 8], 0
            //   7408                 | je                  0xa
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   33ff                 | xor                 edi, edi
            //   391e                 | cmp                 dword ptr [esi], ebx
            //   75e1                 | jne                 0xffffffe3
            //   85ff                 | test                edi, edi

        $sequence_3 = { e8???????? 8b35???????? 81fe???????? 59 7470 395e08 746b }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8b35????????         |                     
            //   81fe????????         |                     
            //   59                   | pop                 ecx
            //   7470                 | je                  0x72
            //   395e08               | cmp                 dword ptr [esi + 8], ebx
            //   746b                 | je                  0x6d

        $sequence_4 = { 8b0d???????? 85c9 7503 33c0 c3 8bc1 56 }
            // n = 7, score = 400
            //   8b0d????????         |                     
            //   85c9                 | test                ecx, ecx
            //   7503                 | jne                 5
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   8bc1                 | mov                 eax, ecx
            //   56                   | push                esi

        $sequence_5 = { 8b4510 59 59 8b4d18 85c9 8945d8 8b4514 }
            // n = 7, score = 400
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   85c9                 | test                ecx, ecx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_6 = { ff35???????? ff742414 e8???????? 85c0 59 59 7474 }
            // n = 7, score = 400
            //   ff35????????         |                     
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   7474                 | je                  0x76

        $sequence_7 = { 50 687e660480 56 897d08 ffd3 83f8ff 750d }
            // n = 7, score = 400
            //   50                   | push                eax
            //   687e660480           | push                0x8004667e
            //   56                   | push                esi
            //   897d08               | mov                 dword ptr [ebp + 8], edi
            //   ffd3                 | call                ebx
            //   83f8ff               | cmp                 eax, -1
            //   750d                 | jne                 0xf

        $sequence_8 = { c745f001000000 eb46 53 ff7510 8d443730 50 }
            // n = 6, score = 400
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   eb46                 | jmp                 0x48
            //   53                   | push                ebx
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d443730             | lea                 eax, [edi + esi + 0x30]
            //   50                   | push                eax

        $sequence_9 = { 8b7508 83c608 8bc6 8d4801 8a10 40 3ad3 }
            // n = 7, score = 400
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   83c608               | add                 esi, 8
            //   8bc6                 | mov                 eax, esi
            //   8d4801               | lea                 ecx, [eax + 1]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax
            //   3ad3                 | cmp                 dl, bl

    condition:
        7 of them and filesize < 147456
}