rule win_tor_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tor_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tor_loader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 488d05f2573000 bb02000000 e8???????? 488b842420010000 488b4c2440 4829c8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d05f2573000       | mov                 edx, dword ptr [edx + 0x38]
            //   bb02000000           | dec                 esp
            //   e8????????           |                     
            //   488b842420010000     | cmp                 edx, edi
            //   488b4c2440           | jbe                 0xc17
            //   4829c8               | dec                 ecx

        $sequence_1 = { e8???????? 833d????????00 750b 488b542470 48894218 eb1b 488b7c2470 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   833d????????00       |                     
            //   750b                 | dec                 ebx
            //   488b542470           | lea                 ebx, [eax + ecx]
            //   48894218             | dec                 eax
            //   eb1b                 | cmp                 ecx, edi
            //   488b7c2470           | jl                  0x1628

        $sequence_2 = { eb0c c6441c5000 48ffcb 0f1f4000 4839da 7f81 4883fb10 }
            // n = 7, score = 100
            //   eb0c                 | dec                 ecx
            //   c6441c5000           | mov                 ecx, dword ptr [eax]
            //   48ffcb               | dec                 eax
            //   0f1f4000             | mov                 dword ptr [esp + 0x198], ecx
            //   4839da               | inc                 ecx
            //   7f81                 | movups              xmm0, xmmword ptr [eax + 8]
            //   4883fb10             | movups              xmmword ptr [esp + 0x1a0], xmm0

        $sequence_3 = { ebaf 488b542450 4c8b442448 4c39c2 488b942490000000 7d0c 4c8d0d97051200 }
            // n = 7, score = 100
            //   ebaf                 | dec                 eax
            //   488b542450           | lea                 esi, [0x102d92]
            //   4c8b442448           | dec                 eax
            //   4c39c2               | mov                 edx, dword ptr [esp + 0x40]
            //   488b942490000000     | dec                 esp
            //   7d0c                 | mov                 eax, dword ptr [esp + 0x48]
            //   4c8d0d97051200       | dec                 ecx

        $sequence_4 = { eb0c 488d3da3fb3200 e8???????? 488b0d???????? 48898c24f0030000 488d0500bc0900 e8???????? }
            // n = 7, score = 100
            //   eb0c                 | dec                 eax
            //   488d3da3fb3200       | mov                 dword ptr [esp + 0x5a8], eax
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   48898c24f0030000     | inc                 ecx
            //   488d0500bc0900       | mov                 eax, 0x1ff
            //   e8????????           |                     

        $sequence_5 = { f7d7 4121ff 488b8424d0000000 488b4c2458 488b742448 488bbc2488000000 4c8b442438 }
            // n = 7, score = 100
            //   f7d7                 | dec                 eax
            //   4121ff               | lea                 eax, [0x1416ab]
            //   488b8424d0000000     | dec                 esp
            //   488b4c2458           | mov                 esi, ebx
            //   488b742448           | dec                 ebp
            //   488bbc2488000000     | mov                 eax, esp
            //   4c8b442438           | dec                 ebp

        $sequence_6 = { e8???????? 84c0 0f85e5000000 0fb644243f e8???????? 4889442468 48895c2460 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | dec                 eax
            //   0f85e5000000         | mov                 esi, dword ptr [esp + 0x5b0]
            //   0fb644243f           | dec                 esp
            //   e8????????           |                     
            //   4889442468           | add                 esi, esp
            //   48895c2460           | dec                 eax

        $sequence_7 = { e8???????? 488b842490000000 6690 e8???????? 488d051d533100 bb0f000000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b842490000000     | jne                 0x25c
            //   6690                 | dec                 ecx
            //   e8????????           |                     
            //   488d051d533100       | and                 edx, edx
            //   bb0f000000           | dec                 ecx
            //   e8????????           |                     

        $sequence_8 = { e8???????? 488d05291f3300 bb20000000 0f1f440000 e8???????? 488d05f31e3300 bb20000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d05291f3300       | dec                 ecx
            //   bb20000000           | cmp                 esp, dword ptr [esi + 0x10]
            //   0f1f440000           | jbe                 0x959
            //   e8????????           |                     
            //   488d05f31e3300       | dec                 eax
            //   bb20000000           | sub                 esp, 0x28

        $sequence_9 = { e8???????? 90 8b9424c0000000 83fa7f 7746 49ffc0 4c39c1 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | dec                 esp
            //   8b9424c0000000       | mov                 ecx, dword ptr [esp + 0x810]
            //   83fa7f               | dec                 esp
            //   7746                 | adc                 esi, ecx
            //   49ffc0               | dec                 esp
            //   4c39c1               | adc                 edx, eax

    condition:
        7 of them and filesize < 13050880
}