rule win_turian_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.turian."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.turian"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf0 85f6 7405 83c605 }
            // n = 4, score = 400
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7405                 | je                  7
            //   83c605               | add                 esi, 5

        $sequence_1 = { 5b 81c420040000 c3 8d4c2410 6a10 51 }
            // n = 6, score = 400
            //   5b                   | pop                 ebx
            //   81c420040000         | add                 esp, 0x420
            //   c3                   | ret                 
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   6a10                 | push                0x10
            //   51                   | push                ecx

        $sequence_2 = { 50 53 52 ff15???????? eb1b }
            // n = 5, score = 400
            //   50                   | push                eax
            //   53                   | push                ebx
            //   52                   | push                edx
            //   ff15????????         |                     
            //   eb1b                 | jmp                 0x1d

        $sequence_3 = { bf???????? f3a5 668b15???????? 52 }
            // n = 4, score = 400
            //   bf????????           |                     
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   668b15????????       |                     
            //   52                   | push                edx

        $sequence_4 = { 56 c1e105 03c8 57 8b7c2410 }
            // n = 5, score = 400
            //   56                   | push                esi
            //   c1e105               | shl                 ecx, 5
            //   03c8                 | add                 ecx, eax
            //   57                   | push                edi
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]

        $sequence_5 = { 83c9ff 33c0 668b15???????? f2ae }
            // n = 4, score = 400
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   668b15????????       |                     
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_6 = { 81c49c000000 c3 6a00 6a00 8d4c2424 688c000000 51 }
            // n = 7, score = 400
            //   81c49c000000         | add                 esp, 0x9c
            //   c3                   | ret                 
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   688c000000           | push                0x8c
            //   51                   | push                ecx

        $sequence_7 = { 0f8502010000 8b1d???????? 8b2d???????? 8d442410 50 e8???????? 83c404 }
            // n = 7, score = 400
            //   0f8502010000         | jne                 0x108
            //   8b1d????????         |                     
            //   8b2d????????         |                     
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_8 = { 6a16 8901 8bd5 56 894104 }
            // n = 5, score = 400
            //   6a16                 | push                0x16
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8bd5                 | mov                 edx, ebp
            //   56                   | push                esi
            //   894104               | mov                 dword ptr [ecx + 4], eax

        $sequence_9 = { 52 49 baff000000 68???????? 2bd1 }
            // n = 5, score = 400
            //   52                   | push                edx
            //   49                   | dec                 ecx
            //   baff000000           | mov                 edx, 0xff
            //   68????????           |                     
            //   2bd1                 | sub                 edx, ecx

    condition:
        7 of them and filesize < 645120
}