rule win_turla_rpc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.turla_rpc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.turla_rpc"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745b06970746f c745b472536163 66c745b86c00 ff15???????? }
            // n = 4, score = 200
            //   c745b06970746f       | mov                 word ptr [ebp - 0x7c], 0x3021
            //   c745b472536163       | mov                 byte ptr [ebp - 0x7a], 0x55
            //   66c745b86c00         | mov                 dword ptr [esp + 0x68], 0x39393438
            //   ff15????????         |                     

        $sequence_1 = { 66c7852c0100002626 c6852e01000055 c745b0193a3431 c745b4193c3727 c745b834272c14 c645bc55 c7854001000030163930 }
            // n = 7, score = 200
            //   66c7852c0100002626     | mov    word ptr [ebp + 0x12c], 0x2626
            //   c6852e01000055       | mov                 byte ptr [ebp + 0x12e], 0x55
            //   c745b0193a3431       | mov                 dword ptr [ebp - 0x50], 0x31343a19
            //   c745b4193c3727       | mov                 dword ptr [ebp - 0x4c], 0x27373c19
            //   c745b834272c14       | mov                 dword ptr [ebp - 0x48], 0x142c2734
            //   c645bc55             | mov                 byte ptr [ebp - 0x44], 0x55
            //   c7854001000030163930     | mov    dword ptr [ebp + 0x140], 0x30391630

        $sequence_2 = { c645bc55 c7854001000030163930 c78544010000343b2025 c6854801000055 }
            // n = 4, score = 200
            //   c645bc55             | mov                 byte ptr [ebp - 0x72], 0x55
            //   c7854001000030163930     | mov    dword ptr [esp + 0x50], 0x34302733
            //   c78544010000343b2025     | mov    word ptr [esp + 0x54], 0x5531
            //   c6854801000055       | mov                 byte ptr [ebp - 0x44], 0x55

        $sequence_3 = { 66c785ec0000000255 c785a0000000193a3431 c785a4000000193c3727 c785a800000034272c02 }
            // n = 4, score = 200
            //   66c785ec0000000255     | mov    dword ptr [esp + 0x50], 0x34302733
            //   c785a0000000193a3431     | mov    word ptr [esp + 0x54], 0x5531
            //   c785a4000000193c3727     | mov    dword ptr [esp + 0x30], 0x30302733
            //   c785a800000034272c02     | mov    word ptr [ebp + 0xec], 0x5502

        $sequence_4 = { 66c7850c0100003a3b c6850e01000055 c745c007303431 c745c4133c3930 c645c855 c744244806393030 }
            // n = 6, score = 200
            //   66c7850c0100003a3b     | mov    word ptr [ebp + 0x10c], 0x3b3a
            //   c6850e01000055       | mov                 byte ptr [ebp + 0x10e], 0x55
            //   c745c007303431       | mov                 dword ptr [ebp - 0x40], 0x31343007
            //   c745c4133c3930       | mov                 dword ptr [ebp - 0x3c], 0x30393c13
            //   c645c855             | mov                 byte ptr [ebp - 0x38], 0x55
            //   c744244806393030     | mov                 dword ptr [esp + 0x48], 0x30303906

        $sequence_5 = { c3 488d053bda0000 488d542458 488d4c2420 }
            // n = 4, score = 200
            //   c3                   | ret                 
            //   488d053bda0000       | dec                 eax
            //   488d542458           | lea                 eax, [0xda3b]
            //   488d4c2420           | dec                 eax

        $sequence_6 = { c785f800000021133c39 66c785fc0000003002 c685fe00000055 c785d000000012302113 }
            // n = 4, score = 200
            //   c785f800000021133c39     | lea    edx, [esp + 0x58]
            //   66c785fc0000003002     | dec    eax
            //   c685fe00000055       | lea                 ecx, [esp + 0x20]
            //   c785d000000012302113     | mov    dword ptr [ebp + 0xf8], 0x393c1321

        $sequence_7 = { c78544010000343b2025 c6854801000055 c78560010000013c3830 c785640100003a202155 }
            // n = 4, score = 200
            //   c78544010000343b2025     | mov    dword ptr [ebp + 0x144], 0x25203b34
            //   c6854801000055       | mov                 byte ptr [ebp + 0x148], 0x55
            //   c78560010000013c3830     | mov    dword ptr [ebp + 0x160], 0x30383c01
            //   c785640100003a202155     | mov    dword ptr [ebp + 0x164], 0x5521203a

        $sequence_8 = { c644247e55 c745883336393a 66c7458c2630 c6458e55 c744245033273034 66c74424543155 c744243033273030 }
            // n = 7, score = 200
            //   c644247e55           | mov                 word ptr [ebp + 0xfc], 0x230
            //   c745883336393a       | mov                 byte ptr [ebp + 0xfe], 0x55
            //   66c7458c2630         | mov                 dword ptr [ebp + 0xd0], 0x13213012
            //   c6458e55             | mov                 byte ptr [esp + 0x7e], 0x55
            //   c744245033273034     | mov                 dword ptr [ebp - 0x78], 0x3a393633
            //   66c74424543155       | mov                 word ptr [ebp - 0x74], 0x3026
            //   c744243033273030     | mov                 byte ptr [ebp - 0x72], 0x55

        $sequence_9 = { 6a01 8d45bc 50 ff9540ffffff 8d8550ffffff 50 8d8548ffffff }
            // n = 7, score = 100
            //   6a01                 | mov                 word ptr [ebp - 0x154], 0x6574
            //   8d45bc               | mov                 byte ptr [ebp - 0x152], 0
            //   50                   | mov                 dword ptr [ebp - 0x160], 0x6c6c616d
            //   ff9540ffffff         | push                1
            //   8d8550ffffff         | lea                 eax, [ebp - 0x44]
            //   50                   | push                eax
            //   8d8548ffffff         | call                dword ptr [ebp - 0xc0]

        $sequence_10 = { 8d8588feffff 50 57 ff9570fdffff 8b8d6cfdffff 89413c }
            // n = 6, score = 100
            //   8d8588feffff         | push                dword ptr [ebp + 0xc]
            //   50                   | push                dword ptr [edi]
            //   57                   | push                esi
            //   ff9570fdffff         | lea                 eax, [ebp - 0x178]
            //   8b8d6cfdffff         | push                eax
            //   89413c               | push                edi

        $sequence_11 = { 5d c20400 8b1d???????? 8d4900 8d44243c 50 ff15???????? }
            // n = 7, score = 100
            //   5d                   | call                dword ptr [ebp - 0x290]
            //   c20400               | mov                 ecx, dword ptr [ebp - 0x294]
            //   8b1d????????         |                     
            //   8d4900               | mov                 dword ptr [ecx + 0x3c], eax
            //   8d44243c             | pop                 ebp
            //   50                   | ret                 4
            //   ff15????????         |                     

        $sequence_12 = { 8b7dbc 57 ff15???????? 83c404 }
            // n = 4, score = 100
            //   8b7dbc               | lea                 eax, [ebp - 0xb0]
            //   57                   | push                eax
            //   ff15????????         |                     
            //   83c404               | lea                 eax, [ebp - 0xb8]

        $sequence_13 = { 50 50 688f000000 ff15???????? 56 }
            // n = 5, score = 100
            //   50                   | mov                 edi, dword ptr [ebp - 0x44]
            //   50                   | push                edi
            //   688f000000           | add                 esp, 4
            //   ff15????????         |                     
            //   56                   | push                eax

        $sequence_14 = { 66c785bcfeffff6b00 c785c8feffff6674656c 66c785ccfeffff6c00 c785a8feffff66777269 66c785acfeffff7465 c685aefeffff00 c785a0feffff6d616c6c }
            // n = 7, score = 100
            //   66c785bcfeffff6b00     | lea    ecx, [ecx]
            //   c785c8feffff6674656c     | lea    eax, [esp + 0x3c]
            //   66c785ccfeffff6c00     | push    eax
            //   c785a8feffff66777269     | mov    word ptr [ebp - 0x144], 0x6b
            //   66c785acfeffff7465     | mov    dword ptr [ebp - 0x138], 0x6c657466
            //   c685aefeffff00       | mov                 word ptr [ebp - 0x134], 0x6c
            //   c785a0feffff6d616c6c     | mov    dword ptr [ebp - 0x158], 0x69727766

        $sequence_15 = { 6a00 8d45f8 50 ff750c ff37 56 }
            // n = 6, score = 100
            //   6a00                 | mov                 dword ptr [ebp - 0x50], 0x6f747069
            //   8d45f8               | mov                 dword ptr [ebp - 0x4c], 0x63615372
            //   50                   | mov                 word ptr [ebp - 0x48], 0x6c
            //   ff750c               | push                0
            //   ff37                 | lea                 eax, [ebp - 8]
            //   56                   | push                eax

    condition:
        7 of them and filesize < 311296
}