rule win_typeframe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.typeframe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.typeframe"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 004fb5 0500cccccc cc 48895c2410 }
            // n = 4, score = 100
            //   004fb5               | cmp                 al, 0x75
            //   0500cccccc           | add                 eax, dword ptr [eax]
            //   cc                   | add                 byte ptr [edi - 0x4b], cl
            //   48895c2410           | add                 eax, 0xcccccc00

        $sequence_1 = { 002d???????? b505 00eb b405 }
            // n = 4, score = 100
            //   002d????????         |                     
            //   b505                 | mov                 dword ptr [esp + 0x10], ebx
            //   00eb                 | push                ebp
            //   b405                 | mov                 ch, 5

        $sequence_2 = { 004775 0300 3c75 0300 }
            // n = 4, score = 100
            //   004775               | mov                 ch, 5
            //   0300                 | add                 byte ptr [edi - 0x4b], cl
            //   3c75                 | add                 byte ptr [edi + 0x75], al
            //   0300                 | add                 eax, dword ptr [eax]

        $sequence_3 = { 0026 b505 004fb5 0500cccccc }
            // n = 4, score = 100
            //   0026                 | add                 byte ptr [esi], ah
            //   b505                 | mov                 ch, 5
            //   004fb5               | add                 byte ptr [edi - 0x4b], cl
            //   0500cccccc           | add                 eax, 0xcccccc00

        $sequence_4 = { 006a0f 57 8bf0 e8???????? }
            // n = 4, score = 100
            //   006a0f               | add                 byte ptr [edx + 0xf], ch
            //   57                   | push                edi
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     

        $sequence_5 = { 0004af 0300 f6ae0300e8ae 0300 }
            // n = 4, score = 100
            //   0004af               | add                 byte ptr [edi + ebp*4], al
            //   0300                 | add                 eax, dword ptr [eax]
            //   f6ae0300e8ae         | imul                byte ptr [esi - 0x5117fffd]
            //   0300                 | add                 eax, dword ptr [eax]

        $sequence_6 = { 01442468 8d4c0f78 83e978 8d44242c }
            // n = 4, score = 100
            //   01442468             | add                 dword ptr [esp + 0x68], eax
            //   8d4c0f78             | lea                 ecx, [edi + ecx + 0x78]
            //   83e978               | sub                 ecx, 0x78
            //   8d44242c             | lea                 eax, [esp + 0x2c]

        $sequence_7 = { 0056e5 0400 af e504 }
            // n = 4, score = 100
            //   0056e5               | int3                
            //   0400                 | dec                 eax
            //   af                   | mov                 dword ptr [esp + 0x10], ebx
            //   e504                 | push                ebp

        $sequence_8 = { 0102 0318 18040506071818 1818 }
            // n = 4, score = 100
            //   0102                 | add                 dword ptr [edx], eax
            //   0318                 | add                 ebx, dword ptr [eax]
            //   18040506071818       | sbb                 byte ptr [eax + 0x18180706], al
            //   1818                 | sbb                 byte ptr [eax], bl

        $sequence_9 = { 008601010000 0fb69601010000 410fb60c30 0fb60432 }
            // n = 4, score = 100
            //   008601010000         | movzx               ecx, byte ptr [eax + ebp]
            //   0fb69601010000       | movzx               edx, byte ptr [ebp + 0x101]
            //   410fb60c30           | movzx               eax, byte ptr [edx + ebp]
            //   0fb60432             | inc                 ecx

        $sequence_10 = { 0108 83c004 4a 75cd }
            // n = 4, score = 100
            //   0108                 | add                 dword ptr [eax], ecx
            //   83c004               | add                 eax, 4
            //   4a                   | dec                 edx
            //   75cd                 | jne                 0xffffffcf

        $sequence_11 = { 014424fc 83ec04 2bc1 58 0f83be000000 }
            // n = 5, score = 100
            //   014424fc             | add                 dword ptr [esp - 4], eax
            //   83ec04               | sub                 esp, 4
            //   2bc1                 | sub                 eax, ecx
            //   58                   | pop                 eax
            //   0f83be000000         | jae                 0xc4

        $sequence_12 = { 008501010000 410fb60c28 0fb69501010000 0fb6042a }
            // n = 4, score = 100
            //   008501010000         | add                 byte ptr [esi - 0x1b], dl
            //   410fb60c28           | add                 al, 0
            //   0fb69501010000       | scasd               eax, dword ptr es:[edi]
            //   0fb6042a             | in                  eax, 4

        $sequence_13 = { 01442408 c74424fc00000000 014c24fc 83ec04 }
            // n = 4, score = 100
            //   01442408             | add                 dword ptr [esp + 8], eax
            //   c74424fc00000000     | mov                 dword ptr [esp - 4], 0
            //   014c24fc             | add                 dword ptr [esp - 4], ecx
            //   83ec04               | sub                 esp, 4

        $sequence_14 = { 01442418 8d6c282c 83ed2c eb04 }
            // n = 4, score = 100
            //   01442418             | add                 dword ptr [esp + 0x18], eax
            //   8d6c282c             | lea                 ebp, [eax + ebp + 0x2c]
            //   83ed2c               | sub                 ebp, 0x2c
            //   eb04                 | jmp                 6

        $sequence_15 = { 014424fc 83ec04 2bc2 58 720c }
            // n = 5, score = 100
            //   014424fc             | add                 dword ptr [esp - 4], eax
            //   83ec04               | sub                 esp, 4
            //   2bc2                 | sub                 eax, edx
            //   58                   | pop                 eax
            //   720c                 | jb                  0xe

    condition:
        7 of them and filesize < 2125824
}