rule win_ufrstealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ufrstealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ufrstealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb68 68???????? 68???????? ff15???????? 68???????? 68???????? ff15???????? }
            // n = 7, score = 200
            //   eb68                 | jmp                 0x6a
            //   68????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   68????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_1 = { 0f8539010000 c745e000000000 c745d400020000 c745d800020000 8d45d8 50 68???????? }
            // n = 7, score = 200
            //   0f8539010000         | jne                 0x13f
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0
            //   c745d400020000       | mov                 dword ptr [ebp - 0x2c], 0x200
            //   c745d800020000       | mov                 dword ptr [ebp - 0x28], 0x200
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_2 = { 8305????????04 b114 8b15???????? a1???????? 0fadd0 a3???????? }
            // n = 6, score = 200
            //   8305????????04       |                     
            //   b114                 | mov                 cl, 0x14
            //   8b15????????         |                     
            //   a1????????           |                     
            //   0fadd0               | shrd                eax, edx, cl
            //   a3????????           |                     

        $sequence_3 = { ff15???????? 85c0 0f8495e6ffff a3???????? 68???????? ff35???????? }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8495e6ffff         | je                  0xffffe69b
            //   a3????????           |                     
            //   68????????           |                     
            //   ff35????????         |                     

        $sequence_4 = { ff5228 85c0 7527 8b55fc 6a00 6a00 }
            // n = 6, score = 200
            //   ff5228               | call                dword ptr [edx + 0x28]
            //   85c0                 | test                eax, eax
            //   7527                 | jne                 0x29
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 0f84e0020000 8945e0 2b45e4 ff75e4 ff15???????? 50 }
            // n = 6, score = 200
            //   0f84e0020000         | je                  0x2e6
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   2b45e4               | sub                 eax, dword ptr [ebp - 0x1c]
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_6 = { e8???????? 68???????? e8???????? 648f0500000000 83c404 6a00 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   648f0500000000       | pop                 dword ptr fs:[0]
            //   83c404               | add                 esp, 4
            //   6a00                 | push                0

        $sequence_7 = { ff15???????? a1???????? c9 c3 55 8bec 83c4d8 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   a1????????           |                     
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83c4d8               | add                 esp, -0x28

        $sequence_8 = { ff35???????? ff15???????? 85c0 0f847de9ffff a3???????? 68???????? }
            // n = 6, score = 200
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f847de9ffff         | je                  0xffffe983
            //   a3????????           |                     
            //   68????????           |                     

        $sequence_9 = { 33c0 c9 c20400 55 8bec 68???????? ff15???????? }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   68????????           |                     
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 770048
}