rule win_unidentified_013_korean_malware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_013_korean_malware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_013_korean_malware"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 b801000000 eb3f 53 }
            // n = 4, score = 200
            //   83c404               | add                 esp, 4
            //   b801000000           | mov                 eax, 1
            //   eb3f                 | jmp                 0x41
            //   53                   | push                ebx

        $sequence_1 = { 57 8d442418 50 33ff 6a01 }
            // n = 5, score = 200
            //   57                   | push                edi
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   33ff                 | xor                 edi, edi
            //   6a01                 | push                1

        $sequence_2 = { 7304 8d44242c 8a1c38 0fb6cb 51 e8???????? }
            // n = 6, score = 200
            //   7304                 | jae                 6
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   8a1c38               | mov                 bl, byte ptr [eax + edi]
            //   0fb6cb               | movzx               ecx, bl
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_3 = { 68???????? 64a100000000 50 81ec44060000 a1???????? 33c4 89842440060000 }
            // n = 7, score = 200
            //   68????????           |                     
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   81ec44060000         | sub                 esp, 0x644
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   89842440060000       | mov                 dword ptr [esp + 0x640], eax

        $sequence_4 = { 8944240c eb08 c744240cf2030000 8b4c241c 51 ff15???????? 397c240c }
            // n = 7, score = 200
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   eb08                 | jmp                 0xa
            //   c744240cf2030000     | mov                 dword ptr [esp + 0xc], 0x3f2
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   397c240c             | cmp                 dword ptr [esp + 0xc], edi

        $sequence_5 = { 8b7c2418 8b6c2414 8908 8b0d???????? }
            // n = 4, score = 200
            //   8b7c2418             | mov                 edi, dword ptr [esp + 0x18]
            //   8b6c2414             | mov                 ebp, dword ptr [esp + 0x14]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b0d????????         |                     

        $sequence_6 = { 8b2d???????? 8d44240c 50 6800040000 8d4c241c }
            // n = 5, score = 200
            //   8b2d????????         |                     
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   50                   | push                eax
            //   6800040000           | push                0x400
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]

        $sequence_7 = { 43 803c337f 0f85f1feffff 33ff 5b 5d 3bf7 }
            // n = 7, score = 200
            //   43                   | inc                 ebx
            //   803c337f             | cmp                 byte ptr [ebx + esi], 0x7f
            //   0f85f1feffff         | jne                 0xfffffef7
            //   33ff                 | xor                 edi, edi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   3bf7                 | cmp                 esi, edi

        $sequence_8 = { 7419 8d542428 52 e8???????? }
            // n = 4, score = 200
            //   7419                 | je                  0x1b
            //   8d542428             | lea                 edx, [esp + 0x28]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_9 = { e8???????? 83c40c 33ff 8d9b00000000 8a543c14 8d5c2410 88542410 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33ff                 | xor                 edi, edi
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   8a543c14             | mov                 dl, byte ptr [esp + edi + 0x14]
            //   8d5c2410             | lea                 ebx, [esp + 0x10]
            //   88542410             | mov                 byte ptr [esp + 0x10], dl

    condition:
        7 of them and filesize < 204800
}