rule win_unidentified_039_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_039."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_039"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75f6 2bc2 d1f8 0f8596feffff c74534d66e0000 c74524a6290000 c74530f12a0000 }
            // n = 7, score = 100
            //   75f6                 | jne                 0xfffffff8
            //   2bc2                 | sub                 eax, edx
            //   d1f8                 | sar                 eax, 1
            //   0f8596feffff         | jne                 0xfffffe9c
            //   c74534d66e0000       | mov                 dword ptr [ebp + 0x34], 0x6ed6
            //   c74524a6290000       | mov                 dword ptr [ebp + 0x24], 0x29a6
            //   c74530f12a0000       | mov                 dword ptr [ebp + 0x30], 0x2af1

        $sequence_1 = { c745ec0d6a0000 c745e8cc1a0000 c745f065350000 c745e4cc020000 c745e0f4170000 c745dc92210000 83c0a6 }
            // n = 7, score = 100
            //   c745ec0d6a0000       | mov                 dword ptr [ebp - 0x14], 0x6a0d
            //   c745e8cc1a0000       | mov                 dword ptr [ebp - 0x18], 0x1acc
            //   c745f065350000       | mov                 dword ptr [ebp - 0x10], 0x3565
            //   c745e4cc020000       | mov                 dword ptr [ebp - 0x1c], 0x2cc
            //   c745e0f4170000       | mov                 dword ptr [ebp - 0x20], 0x17f4
            //   c745dc92210000       | mov                 dword ptr [ebp - 0x24], 0x2192
            //   83c0a6               | add                 eax, -0x5a

        $sequence_2 = { 23c1 8945f8 8b450c 8b4df4 3bc8 }
            // n = 5, score = 100
            //   23c1                 | and                 eax, ecx
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   3bc8                 | cmp                 ecx, eax

        $sequence_3 = { 57 8b85b0070000 c74594c92f0000 c745982b7d0000 c745a080210000 c74590043b0000 c7458422170000 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8b85b0070000         | mov                 eax, dword ptr [ebp + 0x7b0]
            //   c74594c92f0000       | mov                 dword ptr [ebp - 0x6c], 0x2fc9
            //   c745982b7d0000       | mov                 dword ptr [ebp - 0x68], 0x7d2b
            //   c745a080210000       | mov                 dword ptr [ebp - 0x60], 0x2180
            //   c74590043b0000       | mov                 dword ptr [ebp - 0x70], 0x3b04
            //   c7458422170000       | mov                 dword ptr [ebp - 0x7c], 0x1722

        $sequence_4 = { 8b45f0 0bc8 894de4 8b45f4 }
            // n = 4, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   0bc8                 | or                  ecx, eax
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_5 = { 23c1 8b4d9c 23c1 8b4d98 }
            // n = 4, score = 100
            //   23c1                 | and                 eax, ecx
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   23c1                 | and                 eax, ecx
            //   8b4d98               | mov                 ecx, dword ptr [ebp - 0x68]

        $sequence_6 = { 8b4d0c 3bc8 7d0f ff7508 ff75f4 ff15???????? 89450c }
            // n = 7, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   3bc8                 | cmp                 ecx, eax
            //   7d0f                 | jge                 0x11
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax

        $sequence_7 = { c745ec0d0a0000 8b45ec b99bc3ffff 2bc8 034df0 8b45fc 8b55e8 }
            // n = 7, score = 100
            //   c745ec0d0a0000       | mov                 dword ptr [ebp - 0x14], 0xa0d
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   b99bc3ffff           | mov                 ecx, 0xffffc39b
            //   2bc8                 | sub                 ecx, eax
            //   034df0               | add                 ecx, dword ptr [ebp - 0x10]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]

        $sequence_8 = { 33c8 894de0 8b45ec 8b4df0 3bc8 7c0a 53 }
            // n = 7, score = 100
            //   33c8                 | xor                 ecx, eax
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   3bc8                 | cmp                 ecx, eax
            //   7c0a                 | jl                  0xc
            //   53                   | push                ebx

        $sequence_9 = { 8b4528 05cf7b0000 33c8 894d2c 8b4530 }
            // n = 5, score = 100
            //   8b4528               | mov                 eax, dword ptr [ebp + 0x28]
            //   05cf7b0000           | add                 eax, 0x7bcf
            //   33c8                 | xor                 ecx, eax
            //   894d2c               | mov                 dword ptr [ebp + 0x2c], ecx
            //   8b4530               | mov                 eax, dword ptr [ebp + 0x30]

    condition:
        7 of them and filesize < 262144
}