rule win_unidentified_041_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_041."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_041"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf0 8d45f4 50 8d45f0 50 56 8d45f8 }
            // n = 7, score = 200
            //   8bf0                 | mov                 esi, eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   56                   | push                esi
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_1 = { 64a300000000 8bf1 33ff 8d4c2418 897c240c e8???????? }
            // n = 6, score = 200
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf1                 | mov                 esi, ecx
            //   33ff                 | xor                 edi, edi
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   897c240c             | mov                 dword ptr [esp + 0xc], edi
            //   e8????????           |                     

        $sequence_2 = { ffb5f8bfffff ff15???????? eb67 8d85fcbfffff 50 57 57 }
            // n = 7, score = 200
            //   ffb5f8bfffff         | push                dword ptr [ebp - 0x4008]
            //   ff15????????         |                     
            //   eb67                 | jmp                 0x69
            //   8d85fcbfffff         | lea                 eax, [ebp - 0x4004]
            //   50                   | push                eax
            //   57                   | push                edi
            //   57                   | push                edi

        $sequence_3 = { 6a4a 66894588 83c07d 6689458a 58 6a08 6689458c }
            // n = 7, score = 200
            //   6a4a                 | push                0x4a
            //   66894588             | mov                 word ptr [ebp - 0x78], ax
            //   83c07d               | add                 eax, 0x7d
            //   6689458a             | mov                 word ptr [ebp - 0x76], ax
            //   58                   | pop                 eax
            //   6a08                 | push                8
            //   6689458c             | mov                 word ptr [ebp - 0x74], ax

        $sequence_4 = { ff75fc 56 e8???????? 59 59 2bf7 5f }
            // n = 7, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   2bf7                 | sub                 esi, edi
            //   5f                   | pop                 edi

        $sequence_5 = { eb57 8b45f8 85c0 0f8487000000 8365e000 85c0 7420 }
            // n = 7, score = 200
            //   eb57                 | jmp                 0x59
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   85c0                 | test                eax, eax
            //   0f8487000000         | je                  0x8d
            //   8365e000             | and                 dword ptr [ebp - 0x20], 0
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22

        $sequence_6 = { 50 8d4b04 c78424d400000003000000 e8???????? 83bc248400000010 0f82c1040000 ff742470 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d4b04               | lea                 ecx, [ebx + 4]
            //   c78424d400000003000000     | mov    dword ptr [esp + 0xd4], 3
            //   e8????????           |                     
            //   83bc248400000010     | cmp                 dword ptr [esp + 0x84], 0x10
            //   0f82c1040000         | jb                  0x4c7
            //   ff742470             | push                dword ptr [esp + 0x70]

        $sequence_7 = { ffd6 8bd0 8d4dc0 e8???????? 68???????? 8bd0 c645fc01 }
            // n = 7, score = 200
            //   ffd6                 | call                esi
            //   8bd0                 | mov                 edx, eax
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     
            //   68????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1

        $sequence_8 = { 0f43cf b8???????? 2bc1 50 8d45bc }
            // n = 5, score = 200
            //   0f43cf               | cmovae              ecx, edi
            //   b8????????           |                     
            //   2bc1                 | sub                 eax, ecx
            //   50                   | push                eax
            //   8d45bc               | lea                 eax, [ebp - 0x44]

        $sequence_9 = { 3905???????? 7f2a 3d00010000 7d23 8b5218 85d2 0f849f000000 }
            // n = 7, score = 200
            //   3905????????         |                     
            //   7f2a                 | jg                  0x2c
            //   3d00010000           | cmp                 eax, 0x100
            //   7d23                 | jge                 0x25
            //   8b5218               | mov                 edx, dword ptr [edx + 0x18]
            //   85d2                 | test                edx, edx
            //   0f849f000000         | je                  0xa5

    condition:
        7 of them and filesize < 1097728
}