rule win_unidentified_071_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_071."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_071"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 83fa2b 8bce 0f45c8 33ed 83fa30 894c2428 }
            // n = 7, score = 400
            //   33c0                 | xor                 eax, eax
            //   83fa2b               | cmp                 edx, 0x2b
            //   8bce                 | mov                 ecx, esi
            //   0f45c8               | cmovne              ecx, eax
            //   33ed                 | xor                 ebp, ebp
            //   83fa30               | cmp                 edx, 0x30
            //   894c2428             | mov                 dword ptr [esp + 0x28], ecx

        $sequence_1 = { 740e 8b4d0c ff31 8bc8 e8???????? 8bc8 8b4508 }
            // n = 7, score = 400
            //   740e                 | je                  0x10
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   ff31                 | push                dword ptr [ecx]
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_2 = { a3???????? ff7518 8d45dc 50 ff7510 }
            // n = 5, score = 400
            //   a3????????           |                     
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_3 = { c20800 e8???????? cc 8b4c2404 53 8b5c2410 55 }
            // n = 7, score = 400
            //   c20800               | ret                 8
            //   e8????????           |                     
            //   cc                   | int3                
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   53                   | push                ebx
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]
            //   55                   | push                ebp

        $sequence_4 = { 53 89442418 e8???????? 8bf0 83c8ff 8d4e01 81f9ffffff7f }
            // n = 7, score = 400
            //   53                   | push                ebx
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c8ff               | or                  eax, 0xffffffff
            //   8d4e01               | lea                 ecx, [esi + 1]
            //   81f9ffffff7f         | cmp                 ecx, 0x7fffffff

        $sequence_5 = { 8b4304 8d48ff d3e6 03f6 }
            // n = 4, score = 400
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   d3e6                 | shl                 esi, cl
            //   03f6                 | add                 esi, esi

        $sequence_6 = { 8b33 56 55 e8???????? 8d047d02000000 89742418 }
            // n = 6, score = 400
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   56                   | push                esi
            //   55                   | push                ebp
            //   e8????????           |                     
            //   8d047d02000000       | lea                 eax, [edi*2 + 2]
            //   89742418             | mov                 dword ptr [esp + 0x18], esi

        $sequence_7 = { 84c0 750b 83c618 57 8bce }
            // n = 5, score = 400
            //   84c0                 | test                al, al
            //   750b                 | jne                 0xd
            //   83c618               | add                 esi, 0x18
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi

        $sequence_8 = { e8???????? 8b442424 83c410 c6042b00 83f810 7234 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   83c410               | add                 esp, 0x10
            //   c6042b00             | mov                 byte ptr [ebx + ebp], 0
            //   83f810               | cmp                 eax, 0x10
            //   7234                 | jb                  0x36

        $sequence_9 = { 2bc1 894c2404 3bc2 0f82a9000000 8b4314 55 }
            // n = 6, score = 400
            //   2bc1                 | sub                 eax, ecx
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   3bc2                 | cmp                 eax, edx
            //   0f82a9000000         | jb                  0xaf
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 1220608
}