rule win_unidentified_077_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_077."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_077"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 410fb74716 c1e80d 83e001 48896e58 894620 488d058dfcffff 48894628 }
            // n = 7, score = 600
            //   410fb74716           | lea                 eax, [0x13be2]
            //   c1e80d               | je                  0x20
            //   83e001               | or                  eax, 0xffffffff
            //   48896e58             | lock xadd           dword ptr [ecx], eax
            //   894620               | cmp                 eax, 1
            //   488d058dfcffff       | jne                 0x14
            //   48894628             | dec                 eax

        $sequence_1 = { ba30750000 c744242030750000 448bca 448bc2 488bcf ff15???????? }
            // n = 6, score = 600
            //   ba30750000           | lea                 eax, [0xa2a1]
            //   c744242030750000     | dec                 eax
            //   448bca               | mov                 dword ptr [ebp + 0xf], eax
            //   448bc2               | dec                 eax
            //   488bcf               | lea                 eax, [0xa2a6]
            //   ff15????????         |                     

        $sequence_2 = { 48895c2458 ff15???????? 488bf8 4885c0 750e ff15???????? }
            // n = 6, score = 600
            //   48895c2458           | mov                 ecx, dword ptr [esp + 0x44]
            //   ff15????????         |                     
            //   488bf8               | je                  0x150
            //   4885c0               | mov                 esi, dword ptr [ebp]
            //   750e                 | dec                 ecx
            //   ff15????????         |                     

        $sequence_3 = { 2bcb 3bc8 7653 8bd1 }
            // n = 4, score = 600
            //   2bcb                 | dec                 eax
            //   3bc8                 | ror                 edi, cl
            //   7653                 | dec                 eax
            //   8bd1                 | lea                 ecx, [0xffffca76]

        $sequence_4 = { 4883ec38 33c0 4c8d05b3feffff 4889442428 4533c9 }
            // n = 5, score = 600
            //   4883ec38             | jb                  0x184
            //   33c0                 | inc                 ecx
            //   4c8d05b3feffff       | cmp                 edx, eax
            //   4889442428           | jae                 0x1d1
            //   4533c9               | mov                 eax, edx

        $sequence_5 = { ff15???????? 488bce 418907 ff15???????? }
            // n = 4, score = 600
            //   ff15????????         |                     
            //   488bce               | dec                 esp
            //   418907               | lea                 edi, [0x112c7]
            //   ff15????????         |                     

        $sequence_6 = { 83e03f 2bc8 48d3cf 4933fa 4b87bcf7e0c70100 33c0 }
            // n = 6, score = 600
            //   83e03f               | mov                 ebp, 6
            //   2bc8                 | dec                 eax
            //   48d3cf               | lea                 edi, [ebx + 0x38]
            //   4933fa               | dec                 eax
            //   4b87bcf7e0c70100     | lea                 eax, [0xf91a]
            //   33c0                 | dec                 eax

        $sequence_7 = { 83e001 48896e58 894620 488d058dfcffff 48894628 488d0592fcffff }
            // n = 6, score = 600
            //   83e001               | inc                 edx
            //   48896e58             | cmp                 byte ptr [eax + esi + 0x39], bh
            //   894620               | dec                 eax
            //   488d058dfcffff       | mov                 ecx, dword ptr [eax + 0xf8]
            //   48894628             | dec                 eax
            //   488d0592fcffff       | mov                 eax, dword ptr [ecx]

        $sequence_8 = { e9???????? 493bec 0f84be000000 8b7500 33c0 f04d0fb1bcf180bf0100 }
            // n = 6, score = 600
            //   e9????????           |                     
            //   493bec               | mov                 dword ptr [esp + 0x20], ebx
            //   0f84be000000         | inc                 ebp
            //   8b7500               | xor                 eax, eax
            //   33c0                 | dec                 eax
            //   f04d0fb1bcf180bf0100     | lea    ecx, [0xa8ed]

        $sequence_9 = { 8bc2 f30f6f0418 660fefc1 f30f7f0418 8d4210 }
            // n = 5, score = 600
            //   8bc2                 | dec                 eax
            //   f30f6f0418           | lea                 edx, [0xa911]
            //   660fefc1             | dec                 eax
            //   f30f7f0418           | lea                 ecx, [0xa902]
            //   8d4210               | test                esi, esi

    condition:
        7 of them and filesize < 270336
}