rule win_unidentified_078_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_078."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_078"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83fb11 743f 81fba2000000 7437 89da 83e2fd }
            // n = 6, score = 200
            //   83fb11               | mov                 dword ptr [edx + 0x18], 0
            //   743f                 | dec                 ecx
            //   81fba2000000         | mov                 dword ptr [edx + 8], 0x1000
            //   7437                 | dec                 esp
            //   89da                 | mov                 edx, edx
            //   83e2fd               | dec                 ecx

        $sequence_1 = { 83fa15 760e 83eb5b 83fb01 0f8720010000 eb0f b901003b00 }
            // n = 7, score = 200
            //   83fa15               | dec                 eax
            //   760e                 | lea                 ecx, [0x2b06]
            //   83eb5b               | dec                 eax
            //   83fb01               | lea                 ecx, [0x20bd9]
            //   0f8720010000         | dec                 eax
            //   eb0f                 | lea                 ecx, [0x2af3]
            //   b901003b00           | dec                 eax

        $sequence_2 = { e8???????? ebcb 56 53 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   ebcb                 | ret                 
            //   56                   | dec                 eax
            //   53                   | sub                 esp, 0x38

        $sequence_3 = { 80fa0c 0f8412010000 0f8cee000000 80fa0d 0f8421010000 80fa1b }
            // n = 6, score = 200
            //   80fa0c               | mov                 ecx, dword ptr [eax]
            //   0f8412010000         | dec                 ecx
            //   0f8cee000000         | imul                ecx, esi
            //   80fa0d               | dec                 eax
            //   0f8421010000         | lea                 ebx, [eax + 1]
            //   80fa1b               | jg                  0x96d

        $sequence_4 = { 741b 80fa18 7431 eb6b }
            // n = 4, score = 200
            //   741b                 | inc                 esp
            //   80fa18               | dec                 esp
            //   7431                 | add                 ecx, eax
            //   eb6b                 | movzx               eax, word ptr [ecx + 0x14]

        $sequence_5 = { 7e2b 8a44010f 3c5c 7423 3c2f 741f }
            // n = 6, score = 200
            //   7e2b                 | lea                 eax, [0x2e66]
            //   8a44010f             | dec                 eax
            //   3c5c                 | lea                 eax, [edx + 0x30]
            //   7423                 | dec                 eax
            //   3c2f                 | lea                 eax, [0x3787]
            //   741f                 | dec                 eax

        $sequence_6 = { 7404 ffd0 ebc9 ffd0 }
            // n = 4, score = 200
            //   7404                 | dec                 eax
            //   ffd0                 | mov                 dword ptr [ebx + 0x10], edx
            //   ebc9                 | je                  0x1346
            //   ffd0                 | dec                 ecx

        $sequence_7 = { 80fa5c 0f84cb000000 80fa7e 0f8f02010000 e9???????? ba02000000 e8???????? }
            // n = 7, score = 200
            //   80fa5c               | dec                 eax
            //   0f84cb000000         | mov                 ecx, ebx
            //   80fa7e               | dec                 eax
            //   0f8f02010000         | mov                 edx, dword ptr [edi + ebx*8]
            //   e9????????           |                     
            //   ba02000000           | dec                 esp
            //   e8????????           |                     

        $sequence_8 = { 7514 8a542e10 80fa5c 0f94c1 }
            // n = 4, score = 200
            //   7514                 | dec                 esp
            //   8a542e10             | lea                 ecx, [0x6a85]
            //   80fa5c               | dec                 eax
            //   0f94c1               | mov                 ecx, ebx

        $sequence_9 = { 7437 89da 83e2fd 83fa10 }
            // n = 4, score = 200
            //   7437                 | mov                 eax, dword ptr [esp + 0x80]
            //   89da                 | dec                 esp
            //   83e2fd               | mov                 dword ptr [esp + 0x68], ecx
            //   83fa10               | dec                 eax

    condition:
        7 of them and filesize < 688128
}