rule win_unidentified_103_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_103."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_103"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 896c2408 89442440 8b842434010000 895c2410 8944243c 8b842490000000 89442438 }
            // n = 7, score = 100
            //   896c2408             | mov                 dword ptr [esp], 0
            //   89442440             | call                esi
            //   8b842434010000       | sub                 esp, 0x10
            //   895c2410             | mov                 dword ptr [esp + 0x20], eax
            //   8944243c             | test                eax, eax
            //   8b842490000000       | jne                 0xfffffab4
            //   89442438             | mov                 dword ptr [esp + 8], ebp

        $sequence_1 = { 8b842490000000 ffd0 897c2408 890424 8b8424a8000000 c744240400000000 ffd0 }
            // n = 7, score = 100
            //   8b842490000000       | mov                 dword ptr [esp + 0xd0], edx
            //   ffd0                 | call                eax
            //   897c2408             | mov                 edx, dword ptr [esp + 0xd0]
            //   890424               | mov                 dword ptr [esp + 4], 0
            //   8b8424a8000000       | mov                 dword ptr [esp], eax
            //   c744240400000000     | mov                 eax, dword ptr [esp + 0x90]
            //   ffd0                 | mov                 dword ptr [esp + 0x14], 0

        $sequence_2 = { 57 56 53 83ec5c 8b5c2474 8bac2488000000 8bb4248c000000 }
            // n = 7, score = 100
            //   57                   | sub                 esp, 0x4c
            //   56                   | mov                 esi, dword ptr [edx + 8]
            //   53                   | mov                 dword ptr [esp + 0x20], 1
            //   83ec5c               | mov                 dword ptr [esp + 0x24], 8
            //   8b5c2474             | push                edi
            //   8bac2488000000       | push                esi
            //   8bb4248c000000       | push                ebx

        $sequence_3 = { 890424 8b842414010000 ffd0 83ec10 }
            // n = 4, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   8b842414010000       | mov                 eax, dword ptr [esp + 0x114]
            //   ffd0                 | mov                 dword ptr [esp + 0x1a4], 0
            //   83ec10               | mov                 dword ptr [esp + 0xc], 4

        $sequence_4 = { ffd0 83ec0c 85c0 7417 890424 8b8424f0000000 c744240400000000 }
            // n = 7, score = 100
            //   ffd0                 | sub                 esp, 0xc
            //   83ec0c               | test                eax, eax
            //   85c0                 | je                  0x2c2
            //   7417                 | mov                 eax, dword ptr [esp + 0x198]
            //   890424               | mov                 dword ptr [esp], eax
            //   8b8424f0000000       | mov                 eax, dword ptr [esp + 0x164]
            //   c744240400000000     | call                eax

        $sequence_5 = { ffd5 c744240400000000 890424 89742408 ffd7 83ec0c 85db }
            // n = 7, score = 100
            //   ffd5                 | mov                 edi, dword ptr [esp + 0xa8]
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   890424               | mov                 dword ptr [esp], eax
            //   89742408             | call                edi
            //   ffd7                 | sub                 esp, 0xc
            //   83ec0c               | call                ebp
            //   85db                 | mov                 dword ptr [esp + 8], edi

        $sequence_6 = { 885c242c 8b4c2434 01ea 0fb61c01 885c0204 83c001 83f808 }
            // n = 7, score = 100
            //   885c242c             | jne                 0xd
            //   8b4c2434             | test                edx, edx
            //   01ea                 | je                  0x26
            //   0fb61c01             | mov                 dword ptr [eax + edx*4 - 4], ebp
            //   885c0204             | sub                 edx, 1
            //   83c001               | mov                 byte ptr [edx + eax + 4], bl
            //   83f808               | add                 eax, 1

        $sequence_7 = { 890424 8b8424f0000000 ffd0 83ec08 8b8424b4000000 }
            // n = 5, score = 100
            //   890424               | mov                 eax, dword ptr [esp + 0xf0]
            //   8b8424f0000000       | mov                 dword ptr [esp + 4], 0
            //   ffd0                 | call                eax
            //   83ec08               | sub                 esp, 8
            //   8b8424b4000000       | mov                 dword ptr [esp], eax

        $sequence_8 = { 8d7240 8944245c 8dbc248c000000 89442404 897c2408 893424 }
            // n = 6, score = 100
            //   8d7240               | cmp                 esi, 0x40
            //   8944245c             | je                  0xffffffbd
            //   8dbc248c000000       | lea                 esi, [edx + 1]
            //   89442404             | mov                 byte ptr [ebx], 0
            //   897c2408             | mov                 edi, esi
            //   893424               | mov                 dword ptr [eax + edx*4], ecx

        $sequence_9 = { 31c0 803a00 7415 90 8d742600 83c001 803c0200 }
            // n = 7, score = 100
            //   31c0                 | xor                 eax, eax
            //   803a00               | cpuid               
            //   7415                 | mov                 dword ptr [esp + 0x40], eax
            //   90                   | lea                 eax, [esp + 0x40]
            //   8d742600             | mov                 dword ptr [esp + 0x4c], edx
            //   83c001               | xor                 edx, edx
            //   803c0200             | mov                 dword ptr [esp + 0x44], ebx

    condition:
        7 of them and filesize < 188416
}