rule win_unidentified_115_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_115."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_115"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? b9c8af0000 e8???????? ba01000000 488d0dd4090100 e8???????? 488b05???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b9c8af0000           | inc                 ebp
            //   e8????????           |                     
            //   ba01000000           | mov                 esp, ebx
            //   488d0dd4090100       | add                 esi, edi
            //   e8????????           |                     
            //   488b05????????       |                     

        $sequence_1 = { e8???????? 31c0 eb0e 803c0100 7408 48ffc0 e9???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   31c0                 | inc                 esp
            //   eb0e                 | mov                 esi, ebx
            //   803c0100             | inc                 ebp
            //   7408                 | mov                 esp, eax
            //   48ffc0               | add                 ebp, eax
            //   e9????????           |                     

        $sequence_2 = { 488915???????? 488905???????? 488905???????? 4c891d???????? 4c8d1deda40100 c605????????01 48c705????????00000000 }
            // n = 7, score = 100
            //   488915????????       |                     
            //   488905????????       |                     
            //   488905????????       |                     
            //   4c891d????????       |                     
            //   4c8d1deda40100       | dec                 esp
            //   c605????????01       |                     
            //   48c705????????00000000     |     

        $sequence_3 = { 4589c8 4521d4 01dd 41c1c802 8d1c2a 4489ca c1ca0d }
            // n = 7, score = 100
            //   4589c8               | dec                 eax
            //   4521d4               | lea                 ecx, [eax + 1]
            //   01dd                 | dec                 ecx
            //   41c1c802             | mov                 esi, eax
            //   8d1c2a               | dec                 ebp
            //   4489ca               | mov                 dword ptr [esi + 0x10], ebp
            //   c1ca0d               | dec                 ebp

        $sequence_4 = { 4529d8 488d541010 41ffd2 85c0 0f8490000000 486384249c000000 }
            // n = 6, score = 100
            //   4529d8               | lea                 edx, [0x14913]
            //   488d541010           | dec                 esp
            //   41ffd2               | lea                 ecx, [0x1453d]
            //   85c0                 | dec                 esp
            //   0f8490000000         | lea                 eax, [0x14541]
            //   486384249c000000     | dec                 esp

        $sequence_5 = { 0fc8 8944240c 89442450 8b4224 897c2434 0fc8 }
            // n = 6, score = 100
            //   0fc8                 | dec                 eax
            //   8944240c             | lea                 edx, [0x200bd]
            //   89442450             | dec                 eax
            //   8b4224               | lea                 ecx, [0x16a1a]
            //   897c2434             | dec                 ecx
            //   0fc8                 | lea                 edx, [ecx - 0x180]

        $sequence_6 = { 7f1a 4080fe20 7e22 490fa3f6 731c 400fbed6 4889c1 }
            // n = 7, score = 100
            //   7f1a                 | jne                 0xd17
            //   4080fe20             | dec                 eax
            //   7e22                 | mov                 eax, dword ptr [esp + 0x48]
            //   490fa3f6             | xor                 edx, edx
            //   731c                 | dec                 eax
            //   400fbed6             | cwde                
            //   4889c1               | dec                 eax

        $sequence_7 = { 31ff 4885c9 7403 488b39 488d5910 31f6 4531e4 }
            // n = 7, score = 100
            //   31ff                 | dec                 esp
            //   4885c9               | mov                 ecx, dword ptr [esp + 0x28]
            //   7403                 | dec                 eax
            //   488b39               | mov                 dword ptr [esp + 0x38], eax
            //   488d5910             | dec                 esp
            //   31f6                 | mov                 ecx, ecx
            //   4531e4               | dec                 eax

        $sequence_8 = { 488b0b e8???????? 488b4b08 4889442428 e8???????? 488b15???????? 488b0f }
            // n = 7, score = 100
            //   488b0b               | mov                 edx, ebp
            //   e8????????           |                     
            //   488b4b08             | dec                 eax
            //   4889442428           | mov                 ecx, eax
            //   e8????????           |                     
            //   488b15????????       |                     
            //   488b0f               | dec                 eax

        $sequence_9 = { 4155 4154 57 56 53 4883ec28 31ff }
            // n = 7, score = 100
            //   4155                 | mov                 ebx, dword ptr [esp + 0x30]
            //   4154                 | dec                 eax
            //   57                   | mov                 eax, dword ptr [esp + 0x38]
            //   56                   | shl                 edi, 2
            //   53                   | dec                 eax
            //   4883ec28             | sar                 esi, 4
            //   31ff                 | dec                 eax

    condition:
        7 of them and filesize < 648192
}