rule win_unidentified_116_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_116."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_116"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7718 48 8bd6 48 8d4615 48 894718 }
            // n = 7, score = 100
            //   8b7718               | mov                 esi, dword ptr [edi + 0x18]
            //   48                   | dec                 eax
            //   8bd6                 | mov                 edx, esi
            //   48                   | dec                 eax
            //   8d4615               | lea                 eax, [esi + 0x15]
            //   48                   | dec                 eax
            //   894718               | mov                 dword ptr [edi + 0x18], eax

        $sequence_1 = { c70016000000 e8???????? 48 8b03 bf02000000 48 8b08 }
            // n = 7, score = 100
            //   c70016000000         | mov                 dword ptr [eax], 0x16
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   bf02000000           | mov                 edi, 2
            //   48                   | dec                 eax
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_2 = { 8bf0 48 89442438 48 8bd8 48 89442420 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   48                   | dec                 eax
            //   89442438             | mov                 dword ptr [esp + 0x38], eax
            //   48                   | dec                 eax
            //   8bd8                 | mov                 ebx, eax
            //   48                   | dec                 eax
            //   89442420             | mov                 dword ptr [esp + 0x20], eax

        $sequence_3 = { ba02000000 e8???????? 48 8bcb e8???????? 33c0 48 }
            // n = 7, score = 100
            //   ba02000000           | mov                 edx, 2
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   48                   | dec                 eax

        $sequence_4 = { 8d052146ffff 48 0f45c1 48 8b4c2440 48 33cc }
            // n = 7, score = 100
            //   8d052146ffff         | lea                 eax, [0xffff4621]
            //   48                   | dec                 eax
            //   0f45c1               | cmovne              eax, ecx
            //   48                   | dec                 eax
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   48                   | dec                 eax
            //   33cc                 | xor                 ecx, esp

        $sequence_5 = { e8???????? 33c0 48 83c428 c3 49 8bcb }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   48                   | dec                 eax
            //   83c428               | add                 esp, 0x28
            //   c3                   | ret                 
            //   49                   | dec                 ecx
            //   8bcb                 | mov                 ecx, ebx

        $sequence_6 = { 8bd2 48 8bfa 48 99 49 8bd9 }
            // n = 7, score = 100
            //   8bd2                 | mov                 edx, edx
            //   48                   | dec                 eax
            //   8bfa                 | mov                 edi, edx
            //   48                   | dec                 eax
            //   99                   | cdq                 
            //   49                   | dec                 ecx
            //   8bd9                 | mov                 ebx, ecx

        $sequence_7 = { 8bcb 660f7f742420 49 8bf1 49 8bf8 e8???????? }
            // n = 7, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   660f7f742420         | movdqa              xmmword ptr [esp + 0x20], xmm6
            //   49                   | dec                 ecx
            //   8bf1                 | mov                 esi, ecx
            //   49                   | dec                 ecx
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     

        $sequence_8 = { 8bf2 4c 8bf9 8b2d???????? b9c8000000 e8???????? 48 }
            // n = 7, score = 100
            //   8bf2                 | mov                 esi, edx
            //   4c                   | dec                 esp
            //   8bf9                 | mov                 edi, ecx
            //   8b2d????????         |                     
            //   b9c8000000           | mov                 ecx, 0xc8
            //   e8????????           |                     
            //   48                   | dec                 eax

        $sequence_9 = { ff4808 834a5802 48 8b4218 48 85c0 7405 }
            // n = 7, score = 100
            //   ff4808               | dec                 dword ptr [eax + 8]
            //   834a5802             | or                  dword ptr [edx + 0x58], 2
            //   48                   | dec                 eax
            //   8b4218               | mov                 eax, dword ptr [edx + 0x18]
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7

    condition:
        7 of them and filesize < 1040384
}