rule win_upas_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.upas."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.upas"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? ff15???????? 8bf8 85ff 7503 40 }
            // n = 6, score = 400
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7503                 | jne                 5
            //   40                   | inc                 eax

        $sequence_1 = { 8d4304 3bc7 0f8496000000 8b450c 397804 0f848a000000 68???????? }
            // n = 7, score = 400
            //   8d4304               | lea                 eax, [ebx + 4]
            //   3bc7                 | cmp                 eax, edi
            //   0f8496000000         | je                  0x9c
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   397804               | cmp                 dword ptr [eax + 4], edi
            //   0f848a000000         | je                  0x90
            //   68????????           |                     

        $sequence_2 = { 85c0 7441 397d18 740f 53 57 ffd6 }
            // n = 7, score = 400
            //   85c0                 | test                eax, eax
            //   7441                 | je                  0x43
            //   397d18               | cmp                 dword ptr [ebp + 0x18], edi
            //   740f                 | je                  0x11
            //   53                   | push                ebx
            //   57                   | push                edi
            //   ffd6                 | call                esi

        $sequence_3 = { 0f85fd000000 8d45fc 50 57 57 6a03 }
            // n = 6, score = 400
            //   0f85fd000000         | jne                 0x103
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   57                   | push                edi
            //   57                   | push                edi
            //   6a03                 | push                3

        $sequence_4 = { 68???????? ff7508 ffd7 ff7508 8b1d???????? ffd3 8d45fc }
            // n = 7, score = 400
            //   68????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd7                 | call                edi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8b1d????????         |                     
            //   ffd3                 | call                ebx
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_5 = { 8b4508 8b403c 5d c3 8b4508 8b4008 }
            // n = 6, score = 400
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b403c               | mov                 eax, dword ptr [eax + 0x3c]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]

        $sequence_6 = { 7507 0bcf 83fe03 7317 83fa04 7512 }
            // n = 6, score = 400
            //   7507                 | jne                 9
            //   0bcf                 | or                  ecx, edi
            //   83fe03               | cmp                 esi, 3
            //   7317                 | jae                 0x19
            //   83fa04               | cmp                 edx, 4
            //   7512                 | jne                 0x14

        $sequence_7 = { 55 8bec 8b450c 48 7413 48 7410 }
            // n = 7, score = 400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   48                   | dec                 eax
            //   7413                 | je                  0x15
            //   48                   | dec                 eax
            //   7410                 | je                  0x12

        $sequence_8 = { ff75fc 83e905 ff75ec c600e9 }
            // n = 4, score = 400
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   83e905               | sub                 ecx, 5
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   c600e9               | mov                 byte ptr [eax], 0xe9

        $sequence_9 = { 897dfc e8???????? 59 8bc8 8945ec }
            // n = 5, score = 400
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bc8                 | mov                 ecx, eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

    condition:
        7 of them and filesize < 114688
}