rule win_valley_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.valley_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.valley_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c20800 53 6a00 6a00 }
            // n = 4, score = 200
            //   c20800               | ret                 8
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_1 = { 5d c20800 53 6a00 6a00 }
            // n = 5, score = 200
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_2 = { 8be5 5d c20800 53 6a00 }
            // n = 5, score = 200
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   53                   | push                ebx
            //   6a00                 | push                0

        $sequence_3 = { e8???????? 8be5 5d c20800 53 6a00 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   53                   | push                ebx
            //   6a00                 | push                0

        $sequence_4 = { e8???????? 8be5 5d c20800 53 6a00 6a00 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 8be5 5d c20800 53 6a00 6a00 }
            // n = 6, score = 200
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_6 = { 33cd e8???????? 8be5 5d c20800 53 6a00 }
            // n = 7, score = 200
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   53                   | push                ebx
            //   6a00                 | push                0

        $sequence_7 = { c745c400000000 e8???????? f6c302 740b 8d8d08ffffff e8???????? 8b5dc0 }
            // n = 7, score = 100
            //   c745c400000000       | mov                 dword ptr [ebp - 0x3c], 0
            //   e8????????           |                     
            //   f6c302               | test                bl, 2
            //   740b                 | je                  0xd
            //   8d8d08ffffff         | lea                 ecx, [ebp - 0xf8]
            //   e8????????           |                     
            //   8b5dc0               | mov                 ebx, dword ptr [ebp - 0x40]

        $sequence_8 = { f30f6f05???????? f30f7f45a8 f30f6f05???????? f30f7f45b8 f30f6f05???????? f30f7f45c8 f30f7e05???????? }
            // n = 7, score = 100
            //   f30f6f05????????     |                     
            //   f30f7f45a8           | movdqu              xmmword ptr [ebp - 0x58], xmm0
            //   f30f6f05????????     |                     
            //   f30f7f45b8           | movdqu              xmmword ptr [ebp - 0x48], xmm0
            //   f30f6f05????????     |                     
            //   f30f7f45c8           | movdqu              xmmword ptr [ebp - 0x38], xmm0
            //   f30f7e05????????     |                     

        $sequence_9 = { 8d45e4 bb03000000 50 8d4dc4 e8???????? 50 8d45d4 }
            // n = 7, score = 100
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   bb03000000           | mov                 ebx, 3
            //   50                   | push                eax
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d45d4               | lea                 eax, [ebp - 0x2c]

    condition:
        7 of them and filesize < 2256896
}