rule win_vanillarat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vanillarat"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 9f 3db065cdc0 ce a3???????? }
            // n = 4, score = 700
            //   9f                   | lahf                
            //   3db065cdc0           | cmp                 eax, 0xc0cd65b0
            //   ce                   | into                
            //   a3????????           |                     

        $sequence_1 = { 51 b200 5e d52a }
            // n = 4, score = 700
            //   51                   | push                ecx
            //   b200                 | mov                 dl, 0
            //   5e                   | pop                 esi
            //   d52a                 | aad                 0x2a

        $sequence_2 = { 9d 5f 7cfe 17 d3d0 }
            // n = 5, score = 700
            //   9d                   | popfd               
            //   5f                   | pop                 edi
            //   7cfe                 | jl                  0
            //   17                   | pop                 ss
            //   d3d0                 | rcl                 eax, cl

        $sequence_3 = { 99 d17855 3e54 b45e 6c a872 c0c951 }
            // n = 7, score = 700
            //   99                   | cdq                 
            //   d17855               | sar                 dword ptr [eax + 0x55], 1
            //   3e54                 | push                esp
            //   b45e                 | mov                 ah, 0x5e
            //   6c                   | insb                byte ptr es:[edi], dx
            //   a872                 | test                al, 0x72
            //   c0c951               | ror                 cl, 0x51

        $sequence_4 = { a872 c0c951 811e8d6ebbc1 676778ca a6 ef d1953f90d905 }
            // n = 7, score = 700
            //   a872                 | test                al, 0x72
            //   c0c951               | ror                 cl, 0x51
            //   811e8d6ebbc1         | sbb                 dword ptr [esi], 0xc1bb6e8d
            //   676778ca             | js                  0xffffffce
            //   a6                   | cmpsb               byte ptr [esi], byte ptr es:[edi]
            //   ef                   | out                 dx, eax
            //   d1953f90d905         | rcl                 dword ptr [ebp + 0x5d9903f], 1

        $sequence_5 = { a3???????? b79e bc8567ee79 c036f1 9d 5f 7cfe }
            // n = 7, score = 700
            //   a3????????           |                     
            //   b79e                 | mov                 bh, 0x9e
            //   bc8567ee79           | mov                 esp, 0x79ee6785
            //   c036f1               | sal                 byte ptr [esi], 0xf1
            //   9d                   | popfd               
            //   5f                   | pop                 edi
            //   7cfe                 | jl                  0

        $sequence_6 = { d17855 3e54 b45e 6c a872 c0c951 811e8d6ebbc1 }
            // n = 7, score = 700
            //   d17855               | sar                 dword ptr [eax + 0x55], 1
            //   3e54                 | push                esp
            //   b45e                 | mov                 ah, 0x5e
            //   6c                   | insb                byte ptr es:[edi], dx
            //   a872                 | test                al, 0x72
            //   c0c951               | ror                 cl, 0x51
            //   811e8d6ebbc1         | sbb                 dword ptr [esi], 0xc1bb6e8d

        $sequence_7 = { 9d 5f 7cfe 17 }
            // n = 4, score = 700
            //   9d                   | popfd               
            //   5f                   | pop                 edi
            //   7cfe                 | jl                  0
            //   17                   | pop                 ss

        $sequence_8 = { ef d1953f90d905 a7 ec }
            // n = 4, score = 700
            //   ef                   | out                 dx, eax
            //   d1953f90d905         | rcl                 dword ptr [ebp + 0x5d9903f], 1
            //   a7                   | cmpsd               dword ptr [esi], dword ptr es:[edi]
            //   ec                   | in                  al, dx

        $sequence_9 = { b45e 6c a872 c0c951 811e8d6ebbc1 676778ca }
            // n = 6, score = 700
            //   b45e                 | mov                 ah, 0x5e
            //   6c                   | insb                byte ptr es:[edi], dx
            //   a872                 | test                al, 0x72
            //   c0c951               | ror                 cl, 0x51
            //   811e8d6ebbc1         | sbb                 dword ptr [esi], 0xc1bb6e8d
            //   676778ca             | js                  0xffffffce

    condition:
        7 of them and filesize < 4867072
}