rule win_varenyky_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.varenyky."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.varenyky"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b3d???????? 8b542418 6a00 52 8d8424c0130000 50 55 }
            // n = 7, score = 100
            //   8b3d????????         |                     
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   6a00                 | push                0
            //   52                   | push                edx
            //   8d8424c0130000       | lea                 eax, [esp + 0x13c0]
            //   50                   | push                eax
            //   55                   | push                ebp

        $sequence_1 = { e8???????? 83c40c 8d4c2414 51 8d54242c 52 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   8d54242c             | lea                 edx, [esp + 0x2c]
            //   52                   | push                edx

        $sequence_2 = { 8d442430 50 55 ffd7 85c0 0f8668010000 }
            // n = 6, score = 100
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   50                   | push                eax
            //   55                   | push                ebp
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   0f8668010000         | jbe                 0x16e

        $sequence_3 = { 8b3d???????? ffd7 6803010000 8d8424a5020000 6a00 50 }
            // n = 6, score = 100
            //   8b3d????????         |                     
            //   ffd7                 | call                edi
            //   6803010000           | push                0x103
            //   8d8424a5020000       | lea                 eax, [esp + 0x2a5]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_4 = { 85c9 743d c60100 41 be???????? }
            // n = 5, score = 100
            //   85c9                 | test                ecx, ecx
            //   743d                 | je                  0x3f
            //   c60100               | mov                 byte ptr [ecx], 0
            //   41                   | inc                 ecx
            //   be????????           |                     

        $sequence_5 = { 57 e8???????? 83c404 3c33 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3c33                 | cmp                 al, 0x33

        $sequence_6 = { e8???????? 83c404 6803010000 8d842445020000 6a00 50 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6803010000           | push                0x103
            //   8d842445020000       | lea                 eax, [esp + 0x245]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_7 = { 6a00 6a06 8d442430 50 55 ffd7 85c0 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a06                 | push                6
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   50                   | push                eax
            //   55                   | push                ebp
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax

        $sequence_8 = { 897b04 c7430801000000 e8???????? 6a06 89430c 8d4310 8d897cfa4000 }
            // n = 7, score = 100
            //   897b04               | mov                 dword ptr [ebx + 4], edi
            //   c7430801000000       | mov                 dword ptr [ebx + 8], 1
            //   e8????????           |                     
            //   6a06                 | push                6
            //   89430c               | mov                 dword ptr [ebx + 0xc], eax
            //   8d4310               | lea                 eax, [ebx + 0x10]
            //   8d897cfa4000         | lea                 ecx, [ecx + 0x40fa7c]

        $sequence_9 = { 8db760fc4000 ff36 e8???????? 83c704 59 8906 83ff28 }
            // n = 7, score = 100
            //   8db760fc4000         | lea                 esi, [edi + 0x40fc60]
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   83c704               | add                 edi, 4
            //   59                   | pop                 ecx
            //   8906                 | mov                 dword ptr [esi], eax
            //   83ff28               | cmp                 edi, 0x28

    condition:
        7 of them and filesize < 24846336
}