rule win_vawtrak_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.vawtrak."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vawtrak"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a01 ff35???????? 6a04 6a01 }
            // n = 4, score = 2700
            //   6a01                 | test                esi, esi
            //   ff35????????         |                     
            //   6a04                 | je                  0x30
            //   6a01                 | xor                 edx, edx

        $sequence_1 = { 6a04 6a01 50 ff15???????? 85c0 }
            // n = 5, score = 2700
            //   6a04                 | push                eax
            //   6a01                 | test                eax, eax
            //   50                   | push                1
            //   ff15????????         |                     
            //   85c0                 | push                4

        $sequence_2 = { 6a00 6a00 e8???????? 50 ff15???????? }
            // n = 5, score = 2600
            //   6a00                 | push                4
            //   6a00                 | push                1
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_3 = { 33c0 b900000080 40 8901 81e900100000 75f6 }
            // n = 6, score = 2400
            //   33c0                 | push                4
            //   b900000080           | push                1
            //   40                   | push                eax
            //   8901                 | push                eax
            //   81e900100000         | push                0
            //   75f6                 | push                0

        $sequence_4 = { c3 56 be???????? 33c0 40 8706 }
            // n = 6, score = 2400
            //   c3                   | push                eax
            //   56                   | push                0
            //   be????????           |                     
            //   33c0                 | push                0
            //   40                   | push                eax
            //   8706                 | xor                 eax, eax

        $sequence_5 = { ba00ff0000 8bc1 23c2 3bc2 }
            // n = 4, score = 2400
            //   ba00ff0000           | push                eax
            //   8bc1                 | push                0
            //   23c2                 | push                0
            //   3bc2                 | push                eax

        $sequence_6 = { eb09 a804 7405 e8???????? 803d????????00 7405 }
            // n = 6, score = 2200
            //   eb09                 | push                eax
            //   a804                 | test                eax, eax
            //   7405                 | jne                 0xfffffff6
            //   e8????????           |                     
            //   803d????????00       |                     
            //   7405                 | inc                 eax

        $sequence_7 = { 85c0 7516 c705????????02000000 c705????????01000000 }
            // n = 4, score = 2200
            //   85c0                 | push                0
            //   7516                 | push                0
            //   c705????????02000000     |     
            //   c705????????01000000     |     

        $sequence_8 = { 6a08 68???????? 56 ffd7 85c0 }
            // n = 5, score = 2100
            //   6a08                 | jne                 0x2a
            //   68????????           |                     
            //   56                   | test                eax, eax
            //   ffd7                 | jne                 8
            //   85c0                 | push                eax

        $sequence_9 = { 7528 68???????? ff15???????? 85c0 7504 }
            // n = 5, score = 2100
            //   7528                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | push                0
            //   7504                 | push                eax

        $sequence_10 = { 50 ff15???????? a3???????? 85c0 74e7 }
            // n = 5, score = 2100
            //   50                   | push                1
            //   ff15????????         |                     
            //   a3????????           |                     
            //   85c0                 | push                eax
            //   74e7                 | test                eax, eax

        $sequence_11 = { e8???????? 33d2 b9ff3f0000 f7f1 }
            // n = 4, score = 2000
            //   e8????????           |                     
            //   33d2                 | jne                 0xa
            //   b9ff3f0000           | test                eax, eax
            //   f7f1                 | jne                 0x2a

        $sequence_12 = { 59 57 8bf0 ff15???????? 8bc6 }
            // n = 5, score = 2000
            //   59                   | je                  0xffffffe9
            //   57                   | test                eax, eax
            //   8bf0                 | jne                 0x2a
            //   ff15????????         |                     
            //   8bc6                 | test                eax, eax

        $sequence_13 = { 8bc6 8703 3bc6 74f8 }
            // n = 4, score = 1900
            //   8bc6                 | mov                 eax, esi
            //   8703                 | xchg                dword ptr [ebx], eax
            //   3bc6                 | cmp                 eax, esi
            //   74f8                 | je                  0xfffffffa

        $sequence_14 = { 56 6a04 53 57 }
            // n = 4, score = 1800
            //   56                   | test                eax, eax
            //   6a04                 | jne                 0xa
            //   53                   | xor                 eax, eax
            //   57                   | pop                 ecx

        $sequence_15 = { 8d429f 3c0f 7705 80ea61 eb0a 8d42bf 3c0f }
            // n = 7, score = 1700
            //   8d429f               | test                eax, eax
            //   3c0f                 | jne                 0xfffffff6
            //   7705                 | mov                 edx, 0xff00
            //   80ea61               | mov                 eax, ecx
            //   eb0a                 | and                 eax, edx
            //   8d42bf               | cmp                 eax, edx
            //   3c0f                 | mov                 eax, esi

        $sequence_16 = { e9???????? 8ac1 c1e904 c0e004 }
            // n = 4, score = 1200
            //   e9????????           |                     
            //   8ac1                 | mov                 al, cl
            //   c1e904               | shr                 ecx, 4
            //   c0e004               | shl                 al, 4

        $sequence_17 = { 8ac8 240f 80e1f0 80c110 32c8 }
            // n = 5, score = 900
            //   8ac8                 | mov                 cl, al
            //   240f                 | and                 al, 0xf
            //   80e1f0               | and                 cl, 0xf0
            //   80c110               | add                 cl, 0x10
            //   32c8                 | xor                 cl, al

        $sequence_18 = { 3c41 7c11 3c46 7f0d }
            // n = 4, score = 800
            //   3c41                 | cmp                 al, 0x41
            //   7c11                 | jl                  0x13
            //   3c46                 | cmp                 al, 0x46
            //   7f0d                 | jg                  0xf

        $sequence_19 = { 42881408 85f6 75de 894b0c eb03 01730c }
            // n = 6, score = 700
            //   42881408             | inc                 edx
            //   85f6                 | mov                 byte ptr [eax + ecx], dl
            //   75de                 | test                esi, esi
            //   894b0c               | jne                 0xffffffe0
            //   eb03                 | mov                 dword ptr [ebx + 0xc], ecx
            //   01730c               | jmp                 5

        $sequence_20 = { 3b4308 0f84e4000000 40883c08 ff430c e9???????? 0f86bf000000 81c7fffeffff }
            // n = 7, score = 700
            //   3b4308               | add                 dword ptr [ebx + 0xc], esi
            //   0f84e4000000         | cmp                 eax, dword ptr [ebx + 8]
            //   40883c08             | je                  0xea
            //   ff430c               | inc                 eax
            //   e9????????           |                     
            //   0f86bf000000         | mov                 byte ptr [eax + ecx], bh
            //   81c7fffeffff         | inc                 dword ptr [ebx + 0xc]

        $sequence_21 = { 48397c2430 7505 bb01000000 8bc3 }
            // n = 4, score = 700
            //   48397c2430           | jbe                 0xc5
            //   7505                 | add                 edi, 0xfffffeff
            //   bb01000000           | dec                 eax
            //   8bc3                 | cmp                 dword ptr [esp + 0x30], edi

        $sequence_22 = { 3b4308 7748 85f6 742a }
            // n = 4, score = 700
            //   3b4308               | cmp                 dword ptr [esp + 0x30], edi
            //   7748                 | jne                 7
            //   85f6                 | mov                 ebx, 1
            //   742a                 | mov                 eax, ebx

    condition:
        7 of them and filesize < 1027072
}