rule win_vhd_ransomware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.vhd_ransomware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vhd_ransomware"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a1???????? 33c5 8945fc 53 8bd9 8b13 57 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   8bd9                 | mov                 ebx, ecx
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   57                   | push                edi

        $sequence_1 = { 83c410 8dbdf0fdffff e8???????? a1???????? e9???????? }
            // n = 5, score = 100
            //   83c410               | add                 esp, 0x10
            //   8dbdf0fdffff         | lea                 edi, [ebp - 0x210]
            //   e8????????           |                     
            //   a1????????           |                     
            //   e9????????           |                     

        $sequence_2 = { 33d2 e8???????? 8b4d08 0bc7 }
            // n = 4, score = 100
            //   33d2                 | xor                 edx, edx
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   0bc7                 | or                  eax, edi

        $sequence_3 = { 8b450c 8902 33c0 89a578f6ffff 39450c 7e11 8d4a04 }
            // n = 7, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8902                 | mov                 dword ptr [edx], eax
            //   33c0                 | xor                 eax, eax
            //   89a578f6ffff         | mov                 dword ptr [ebp - 0x988], esp
            //   39450c               | cmp                 dword ptr [ebp + 0xc], eax
            //   7e11                 | jle                 0x13
            //   8d4a04               | lea                 ecx, [edx + 4]

        $sequence_4 = { 83c404 a1???????? 8b3d???????? 40 6a00 c1e018 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   a1????????           |                     
            //   8b3d????????         |                     
            //   40                   | inc                 eax
            //   6a00                 | push                0
            //   c1e018               | shl                 eax, 0x18

        $sequence_5 = { 8b4d08 85c9 7538 33c0 b9c8000000 }
            // n = 5, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   85c9                 | test                ecx, ecx
            //   7538                 | jne                 0x3a
            //   33c0                 | xor                 eax, eax
            //   b9c8000000           | mov                 ecx, 0xc8

        $sequence_6 = { 333c9598754100 337e04 ff4de8 897804 8b38 }
            // n = 5, score = 100
            //   333c9598754100       | xor                 edi, dword ptr [edx*4 + 0x417598]
            //   337e04               | xor                 edi, dword ptr [esi + 4]
            //   ff4de8               | dec                 dword ptr [ebp - 0x18]
            //   897804               | mov                 dword ptr [eax + 4], edi
            //   8b38                 | mov                 edi, dword ptr [eax]

        $sequence_7 = { f7e2 0f90c1 89b518f0ffff f7d9 0bc8 51 }
            // n = 6, score = 100
            //   f7e2                 | mul                 edx
            //   0f90c1               | seto                cl
            //   89b518f0ffff         | mov                 dword ptr [ebp - 0xfe8], esi
            //   f7d9                 | neg                 ecx
            //   0bc8                 | or                  ecx, eax
            //   51                   | push                ecx

        $sequence_8 = { 8945cc bf40000000 b8???????? 8d75e0 895dc8 c745f40f000000 c745f000000000 }
            // n = 7, score = 100
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   bf40000000           | mov                 edi, 0x40
            //   b8????????           |                     
            //   8d75e0               | lea                 esi, [ebp - 0x20]
            //   895dc8               | mov                 dword ptr [ebp - 0x38], ebx
            //   c745f40f000000       | mov                 dword ptr [ebp - 0xc], 0xf
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0

        $sequence_9 = { d9bd1ee6ffff 0fb7851ee6ffff 0d000c0000 898518e6ffff 43 d9ad18e6ffff db9d18e6ffff }
            // n = 7, score = 100
            //   d9bd1ee6ffff         | fnstcw              word ptr [ebp - 0x19e2]
            //   0fb7851ee6ffff       | movzx               eax, word ptr [ebp - 0x19e2]
            //   0d000c0000           | or                  eax, 0xc00
            //   898518e6ffff         | mov                 dword ptr [ebp - 0x19e8], eax
            //   43                   | inc                 ebx
            //   d9ad18e6ffff         | fldcw               word ptr [ebp - 0x19e8]
            //   db9d18e6ffff         | fistp               dword ptr [ebp - 0x19e8]

    condition:
        7 of them and filesize < 275456
}